/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskInputs;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskOutput;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskSource;
import com.facebook.presto.spark.classloader_interface.SerializedTaskInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.TaskContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.CollectionAccumulator;
import scala.Tuple2;
import scala.collection.Iterator;

public class PrestoSparkTaskProcessor<T extends PrestoSparkTaskOutput>
implements Serializable {
    private final PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider;
    private final SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor;
    private final CollectionAccumulator<SerializedTaskInfo> taskInfoCollector;
    private final CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector;
    private final Map<String, Broadcast<List<PrestoSparkSerializedPage>>> broadcastInputs;
    private final Class<T> outputType;

    public PrestoSparkTaskProcessor(PrestoSparkTaskExecutorFactoryProvider taskExecutorFactoryProvider, SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor, CollectionAccumulator<SerializedTaskInfo> taskInfoCollector, CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector, Map<String, Broadcast<List<PrestoSparkSerializedPage>>> broadcastInputs, Class<T> outputType) {
        this.taskExecutorFactoryProvider = Objects.requireNonNull(taskExecutorFactoryProvider, "taskExecutorFactoryProvider is null");
        this.serializedTaskDescriptor = Objects.requireNonNull(serializedTaskDescriptor, "serializedTaskDescriptor is null");
        this.taskInfoCollector = Objects.requireNonNull(taskInfoCollector, "taskInfoCollector is null");
        this.shuffleStatsCollector = Objects.requireNonNull(shuffleStatsCollector, "shuffleStatsCollector is null");
        this.broadcastInputs = new HashMap<String, Broadcast<List<PrestoSparkSerializedPage>>>(Objects.requireNonNull(broadcastInputs, "broadcastInputs is null"));
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
    }

    public Iterator<Tuple2<MutablePartitionId, T>> process(Iterator<SerializedPrestoSparkTaskSource> serializedTaskSources, Map<String, Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> shuffleInputs) {
        int partitionId = TaskContext.get().partitionId();
        int attemptNumber = TaskContext.get().attemptNumber();
        return this.taskExecutorFactoryProvider.get().create(partitionId, attemptNumber, this.serializedTaskDescriptor, serializedTaskSources, new PrestoSparkTaskInputs(shuffleInputs, this.broadcastInputs, Collections.emptyMap()), this.taskInfoCollector, this.shuffleStatsCollector, this.outputType);
    }
}

