/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.singlestore;

import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UuidType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.inject.Inject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;

public class SingleStoreClient
extends BaseJdbcClient {
    private static final String SQL_STATE_ER_TABLE_EXISTS_ERROR = "42S01";

    @Inject
    public SingleStoreClient(JdbcConnectorId connectorId, BaseJdbcConfig config) {
        super(connectorId, config, "`", (ConnectionFactory)new DriverConnectionFactory((Driver)new com.singlestore.jdbc.Driver(), config.getConnectionUrl(), Optional.ofNullable(config.getUserCredentialName()), Optional.ofNullable(config.getPasswordCredentialName()), SingleStoreClient.connectionProperties(config)));
    }

    private static Properties connectionProperties(BaseJdbcConfig config) {
        Properties connectionProperties = DriverConnectionFactory.basicConnectionProperties((BaseJdbcConfig)config);
        String connectionAttributes = String.format("_connector_name:%s", "SingleStore Presto Connector");
        connectionProperties.setProperty("connectionAttributes", connectionAttributes);
        return connectionProperties;
    }

    protected Collection<String> listSchemas(Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getCatalogs();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("TABLE_CAT");
                    if (this.listSchemasIgnoredSchemas.contains(schemaName.toLowerCase(Locale.ENGLISH))) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    public void abortReadConnection(Connection connection) throws SQLException {
        connection.abort(MoreExecutors.directExecutor());
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getTables(schemaName.orElse(null), null, SingleStoreClient.escapeNamePattern(tableName, escape).orElse(null), new String[]{"TABLE", "VIEW"});
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    protected String toSqlType(Type type) {
        if (RealType.REAL.equals((Object)type)) {
            return "float";
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type) || UuidType.UUID.equals((Object)type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return "datetime";
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return "mediumblob";
        }
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return "longtext";
            }
            if (varcharType.getLengthSafe() <= 255) {
                return "tinytext";
            }
            if (varcharType.getLengthSafe() <= 65535) {
                return "text";
            }
            if (varcharType.getLengthSafe() <= 0xFFFFFF) {
                return "mediumtext";
            }
            return "longtext";
        }
        return super.toSqlType(type);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(tableMetadata, session, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            if (SQL_STATE_ER_TABLE_EXISTS_ERROR.equals(e.getSQLState())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s CHANGE %s %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        super.renameTable(identity, null, oldTable, newTable);
    }

    public String normalizeIdentifier(ConnectorSession session, String identifier) {
        return this.caseSensitiveNameMatchingEnabled ? identifier : identifier.toLowerCase(Locale.ENGLISH);
    }
}

