/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.sql.analyzer.Session;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.http.client.HttpUriBuilder;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/query")
public class QueryResource {
    private static final String NO_CACHE = "no-cache";
    private final QueryManager queryManager;

    @Inject
    public QueryResource(QueryManager queryManager) {
        this.queryManager = (QueryManager)Preconditions.checkNotNull((Object)queryManager, (Object)"queryManager is null");
    }

    @GET
    public List<BasicQueryInfo> getAllQueryInfo() {
        return this.extractBasicQueryInfo(this.queryManager.getAllQueryInfo());
    }

    private List<BasicQueryInfo> extractBasicQueryInfo(List<QueryInfo> allQueryInfo) {
        ImmutableList.Builder basicQueryInfo = ImmutableList.builder();
        for (QueryInfo queryInfo : allQueryInfo) {
            basicQueryInfo.add((Object)new BasicQueryInfo(queryInfo));
        }
        return basicQueryInfo.build();
    }

    @GET
    @Path(value="{queryId}")
    public Response getQueryInfo(@PathParam(value="queryId") QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        try {
            QueryInfo queryInfo = this.queryManager.getQueryInfo(queryId);
            return Response.ok((Object)queryInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response createQuery(String query, @HeaderParam(value="X-Presto-User") String user, @HeaderParam(value="X-Presto-Source") String source, @HeaderParam(value="X-Presto-Catalog") @DefaultValue(value="default") String catalog, @HeaderParam(value="X-Presto-Schema") @DefaultValue(value="default") String schema, @HeaderParam(value="User-Agent") String userAgent, @Context HttpServletRequest requestContext, @Context UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query is empty");
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        Preconditions.checkNotNull((Object)schema, (Object)"schema is null");
        String remoteUserAddress = requestContext.getRemoteAddr();
        QueryInfo queryInfo = this.queryManager.createQuery(new Session(user, source, catalog, schema, remoteUserAddress, userAgent), query);
        URI pagesUri = HttpUriBuilder.uriBuilderFrom((URI)uriInfo.getRequestUri()).appendPath(queryInfo.getQueryId().toString()).build();
        return Response.created((URI)pagesUri).entity((Object)queryInfo).build();
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.queryManager.cancelQuery(queryId);
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

