/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.NoSuchBufferException;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.Page;
import com.facebook.presto.server.TaskUpdateRequest;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/task")
public class TaskResource {
    private static final DataSize DEFAULT_MAX_SIZE = new DataSize(10.0, DataSize.Unit.MEGABYTE);
    private static final Duration DEFAULT_MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private final TaskManager taskManager;

    @Inject
    public TaskResource(TaskManager taskManager) {
        this.taskManager = (TaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public List<TaskInfo> getAllTaskInfo(@Context UriInfo uriInfo) {
        return this.taskManager.getAllTaskInfo(this.isFullTaskInfoRequested(uriInfo));
    }

    @POST
    @Path(value="{taskId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOrUpdateTask(@PathParam(value="taskId") TaskId taskId, TaskUpdateRequest taskUpdateRequest, @Context UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)taskUpdateRequest, (Object)"taskUpdateRequest is null");
        TaskInfo taskInfo = this.taskManager.updateTask(taskUpdateRequest.getSession(), taskId, taskUpdateRequest.getFragment(), taskUpdateRequest.getSources(), taskUpdateRequest.getOutputIds());
        return Response.ok().entity((Object)taskInfo).build();
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public Response getTaskInfo(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo) throws InterruptedException {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        if (maxWait != null) {
            this.taskManager.waitForStateChange(taskId, currentState, maxWait);
        }
        try {
            TaskInfo taskInfo = this.taskManager.getTaskInfo(taskId, this.isFullTaskInfoRequested(uriInfo));
            return Response.ok((Object)taskInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public Response cancelTask(@PathParam(value="taskId") TaskId taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        try {
            TaskInfo taskInfo = this.taskManager.cancelTask(taskId);
            if (taskInfo != null) {
                return Response.ok((Object)taskInfo).build();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="{taskId}/results/{outputId}/{token}")
    @Produces(value={"application/X-presto-pages"})
    public Response getResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="outputId") String outputId, @PathParam(value="token") long token) throws InterruptedException {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        long remainingNanos = DEFAULT_MAX_WAIT_TIME.roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        long end = start + remainingNanos;
        int maxSleepMillis = 1;
        while (remainingNanos > 0L) {
            try {
                BufferResult result = this.taskManager.getTaskResults(taskId, outputId, token, DEFAULT_MAX_SIZE, new Duration((double)remainingNanos, TimeUnit.NANOSECONDS));
                List pages = result.getPages();
                if (!pages.isEmpty()) {
                    GenericEntity entity = new GenericEntity((Object)pages, new TypeToken<List<Page>>(){}.getType());
                    return Response.ok((Object)entity).header("X-Presto-Page-Sequence-Id", (Object)result.getToken()).header("X-Presto-Page-End-Sequence-Id", (Object)result.getNextToken()).build();
                }
                if (result.isBufferClosed()) {
                    return Response.status((Response.Status)Response.Status.GONE).header("X-Presto-Page-Sequence-Id", (Object)result.getToken()).header("X-Presto-Page-End-Sequence-Id", (Object)result.getNextToken()).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Presto-Page-Sequence-Id", (Object)result.getToken()).header("X-Presto-Page-End-Sequence-Id", (Object)result.getNextToken()).build();
            }
            catch (NoSuchBufferException | NoSuchElementException ignored) {
                TimeUnit.NANOSECONDS.sleep(Math.min(remainingNanos, TimeUnit.MILLISECONDS.toNanos(maxSleepMillis)));
                remainingNanos = end - System.nanoTime();
                maxSleepMillis *= 2;
            }
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Presto-Page-Sequence-Id", (Object)token).header("X-Presto-Page-End-Sequence-Id", (Object)token).build();
    }

    @DELETE
    @Path(value="{taskId}/results/{outputId}")
    @Produces(value={"application/json"})
    public Response abortResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="outputId") String outputId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        try {
            TaskInfo taskInfo = this.taskManager.abortTaskResults(taskId, outputId);
            return Response.ok((Object)taskInfo).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private boolean isFullTaskInfoRequested(UriInfo uriInfo) {
        return uriInfo.getQueryParameters().containsKey((Object)"full");
    }
}

