/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.importer.PeriodicImportJob;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.importer.PersistentPeriodicImportJob;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.http.client.HttpUriBuilder;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/import/jobs")
@Singleton
@Produces(value={"application/json"})
public class PeriodicImportJobResource {
    private final PeriodicImportManager periodicImportManager;

    @Inject
    public PeriodicImportJobResource(PeriodicImportManager periodicImportManager) {
        this.periodicImportManager = (PeriodicImportManager)Preconditions.checkNotNull((Object)periodicImportManager, (Object)"Import manager is null");
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createJob(PeriodicImportJob job, @Context UriInfo uriInfo) {
        long id = this.periodicImportManager.insertJob(job);
        URI pagesUri = HttpUriBuilder.uriBuilderFrom((URI)uriInfo.getRequestUri()).appendPath(Long.toString(id)).build();
        return Response.created((URI)pagesUri).build();
    }

    @DELETE
    @Path(value="{jobId: \\d+}")
    public Response dropJob(@PathParam(value="jobId") long jobId) {
        this.periodicImportManager.dropJob(jobId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="{jobId: \\d+}")
    public Response getJob(@PathParam(value="jobId") long jobId) {
        PersistentPeriodicImportJob job = this.periodicImportManager.getJob(jobId);
        if (job == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)job).build();
    }

    @GET
    public Response getAllJobs() {
        return Response.ok((Object)ImmutableMap.of((Object)"jobs", (Object)this.periodicImportManager.getJobs())).build();
    }
}

