/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.discovery.EmbeddedDiscoveryModule;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.ServerMainModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.event.client.HttpEventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.floatingdecimal.FloatingDecimal;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.concurrent.atomic.AtomicBoolean;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    private static final AtomicBoolean codeCacheTriggerInstalled = new AtomicBoolean();

    public static void main(String[] args) {
        new PrestoServer().run();
    }

    private static void installCodeCacheGcTrigger() {
        if (codeCacheTriggerInstalled.getAndSet(true)) {
            return;
        }
        final MemoryPoolMXBean codeCacheMbean = PrestoServer.findCodeCacheMBean();
        Preconditions.checkNotNull((Object)codeCacheMbean, (Object)"Could not obtain a reference to the 'Code Cache' MemoryPoolMXBean");
        Thread gcThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Logger log = Logger.get((String)"Code-Cache-GC-Trigger");
                while (!Thread.currentThread().isInterrupted()) {
                    long max;
                    long used = codeCacheMbean.getUsage().getUsed();
                    if ((double)used > 0.7 * (double)(max = codeCacheMbean.getUsage().getMax())) {
                        log.info("Triggering GC to avoid Code Cache eviction bugs");
                        System.gc();
                    } else if ((double)used > 0.95 * (double)max) {
                        log.error("Code Cache is more than 95% full. JIT may stop working.");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        gcThread.setDaemon(true);
        gcThread.setName("Code-Cache-GC-Trigger");
        gcThread.start();
    }

    private static MemoryPoolMXBean findCodeCacheMBean() {
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!bean.getName().equals("Code Cache")) continue;
            return bean;
        }
        return null;
    }

    @Override
    public void run() {
        Logger log = Logger.get(PrestoServer.class);
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(), new MBeanModule(), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new JsonEventModule(), new HttpEventModule(), new EmbeddedDiscoveryModule(), new ServerMainModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.strictConfig().initialize();
            if (!FloatingDecimal.isPatchInstalled()) {
                log.warn("FloatingDecimal patch not installed. Parallelism will be diminished when parsing/formatting doubles");
            }
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((CatalogManager)injector.getInstance(CatalogManager.class)).loadCatalogs();
            ((Announcer)injector.getInstance(Announcer.class)).start();
            log.info("======== SERVER STARTED ========");
            PrestoServer.installCodeCacheGcTrigger();
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }
}

