/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.operator.Page;
import com.facebook.presto.serde.PagesSerde;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/X-presto-pages"})
@Produces(value={"application/X-presto-pages"})
public class PagesMapper
implements MessageBodyReader<List<Page>>,
MessageBodyWriter<List<Page>> {
    private static final MediaType PRESTO_PAGES_TYPE = MediaType.valueOf((String)"application/X-presto-pages");
    private static final Type LIST_GENERIC_TOKEN;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && TypeToken.of((Type)genericType).resolveType(LIST_GENERIC_TOKEN).getRawType().equals(Page.class) && mediaType.isCompatible(PRESTO_PAGES_TYPE);
    }

    public List<Page> readFrom(Class<List<Page>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream input) throws IOException, WebApplicationException {
        return ImmutableList.copyOf((Iterator)PagesSerde.readPages((SliceInput)new InputStreamSliceInput(input)));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && TypeToken.of((Type)genericType).resolveType(LIST_GENERIC_TOKEN).getRawType().equals(Page.class) && mediaType.isCompatible(PRESTO_PAGES_TYPE);
    }

    public long getSize(List<Page> pages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(List<Page> pages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output) throws IOException, WebApplicationException {
        PagesSerde.writePages((SliceOutput)new OutputStreamSliceOutput(output), pages);
    }

    static {
        try {
            LIST_GENERIC_TOKEN = List.class.getMethod("get", Integer.TYPE).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

