/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.redshift;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.inject.Inject;
import org.postgresql.Driver;

public class RedshiftClient
extends BaseJdbcClient {
    @Inject
    public RedshiftClient(JdbcConnectorId connectorId, BaseJdbcConfig config) throws SQLException {
        super(connectorId, config, "\"", (java.sql.Driver)new Driver());
    }

    public void commitCreateTable(JdbcOutputTableHandle handle) {
        StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName())).append(" RENAME TO ").append(this.quoted(handle.getTableName()));
        try (Connection connection = this.getConnection(handle);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }
}

