/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.csv;

import au.com.bytecode.opencsv.CSVParser;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.decoder.csv.CsvColumnDecoder;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class CsvRowDecoder
implements RowDecoder {
    public static final String NAME = "csv";
    private final Map<DecoderColumnHandle, CsvColumnDecoder> columnDecoders;
    private final CSVParser parser = new CSVParser();

    public CsvRowDecoder(Set<DecoderColumnHandle> columnHandles) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnDecoders = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::createColumnDecoder));
    }

    private CsvColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new CsvColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        String[] tokens;
        try {
            String line = new String(data, StandardCharsets.UTF_8);
            tokens = this.parser.parseLine(line);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.of((Map)this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((CsvColumnDecoder)entry.getValue()).decodeField(tokens))));
    }
}

