/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.facebook.presto.decoder.json.JsonRowDecoderFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ISO8601JsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)DateType.DATE, (Object)TimeType.TIME, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    private final DecoderColumnHandle columnHandle;

    public ISO8601JsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new ISO8601JsonValueProvider(value, this.columnHandle);
    }

    private static class ISO8601JsonValueProvider
    extends FieldValueProvider {
        private final JsonNode value;
        private final DecoderColumnHandle columnHandle;

        public ISO8601JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            this.value = value;
            this.columnHandle = columnHandle;
        }

        @Override
        public boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        @Override
        public long getLong() {
            Type columnType = this.columnHandle.getType();
            if (!this.value.isValueNode()) {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", columnType, this.columnHandle.getName()));
            }
            try {
                String textValue = this.value.asText();
                if (columnType == TimestampType.TIMESTAMP) {
                    TemporalAccessor parseResult = DateTimeFormatter.ISO_DATE_TIME.parse(textValue);
                    return TimeUnit.DAYS.toMillis(parseResult.getLong(ChronoField.EPOCH_DAY)) + parseResult.getLong(ChronoField.MILLI_OF_DAY);
                }
                if (columnType == TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) {
                    TemporalAccessor parseResult = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(textValue);
                    return DateTimeEncoding.packDateTimeWithZone((long)(parseResult.getLong(ChronoField.INSTANT_SECONDS) * 1000L + parseResult.getLong(ChronoField.MILLI_OF_SECOND)), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)ZoneId.from(parseResult).getId()));
                }
                if (columnType == TimeType.TIME) {
                    return DateTimeFormatter.ISO_TIME.parse(textValue).getLong(ChronoField.MILLI_OF_DAY);
                }
                if (columnType == TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) {
                    TemporalAccessor parseResult = DateTimeFormatter.ISO_OFFSET_TIME.parse(textValue);
                    return DateTimeEncoding.packDateTimeWithZone((long)parseResult.get(ChronoField.MILLI_OF_DAY), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)ZoneId.from(parseResult).getId()));
                }
                if (columnType == DateType.DATE) {
                    return DateTimeFormatter.ISO_DATE.parse(textValue).getLong(ChronoField.EPOCH_DAY);
                }
                throw new IllegalArgumentException("unsupported type " + columnType);
            }
            catch (DateTimeParseException e) {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), columnType, this.columnHandle.getName()));
            }
        }
    }
}

