/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.facebook.presto.decoder.json.JsonRowDecoderFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public class DefaultJsonFieldDecoder
implements JsonFieldDecoder {
    private final DecoderColumnHandle columnHandle;
    private final long minValue;
    private final long maxValue;

    public DefaultJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!this.isSupportedType(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
        if (columnHandle.getType() == TinyintType.TINYINT) {
            this.minValue = -128L;
            this.maxValue = 127L;
        } else if (columnHandle.getType() == SmallintType.SMALLINT) {
            this.minValue = -32768L;
            this.maxValue = 32767L;
        } else if (columnHandle.getType() == IntegerType.INTEGER) {
            this.minValue = Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
        } else if (columnHandle.getType() == BigintType.BIGINT) {
            this.minValue = Long.MIN_VALUE;
            this.maxValue = Long.MAX_VALUE;
        } else {
            this.minValue = Long.MAX_VALUE;
            this.maxValue = Long.MIN_VALUE;
        }
    }

    private boolean isSupportedType(Type type) {
        if (Varchars.isVarcharType((Type)type)) {
            return true;
        }
        return ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE).contains((Object)type);
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new JsonValueProvider(value, this.columnHandle, this.minValue, this.maxValue);
    }

    public static class JsonValueProvider
    extends FieldValueProvider {
        private final JsonNode value;
        private final DecoderColumnHandle columnHandle;
        private final long minValue;
        private final long maxValue;

        public JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle, long minValue, long maxValue) {
            this.value = value;
            this.columnHandle = columnHandle;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public final boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        @Override
        public boolean getBoolean() {
            if (this.value.isValueNode()) {
                return this.value.asBoolean();
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
        }

        @Override
        public long getLong() {
            try {
                long longValue;
                if (this.value.isIntegralNumber() && !this.value.isBigInteger()) {
                    long longValue2 = this.value.longValue();
                    if (longValue2 >= this.minValue && longValue2 <= this.maxValue) {
                        return longValue2;
                    }
                } else if (this.value.isValueNode() && (longValue = Long.parseLong(this.value.asText())) >= this.minValue && longValue <= this.maxValue) {
                    return longValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
        }

        @Override
        public double getDouble() {
            try {
                if (this.value.isNumber()) {
                    return this.value.doubleValue();
                }
                if (this.value.isValueNode()) {
                    return Double.parseDouble(this.value.asText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
        }

        @Override
        public Slice getSlice() {
            String textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            Slice slice = Slices.utf8Slice((String)textValue);
            if (Varchars.isVarcharType((Type)this.columnHandle.getType())) {
                slice = Varchars.truncateToLength((Slice)slice, (Type)this.columnHandle.getType());
            }
            return slice;
        }
    }
}

