/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.TimeUnit;

public abstract class AbstractDateTimeJsonValueProvider
extends FieldValueProvider {
    protected final JsonNode value;
    protected final DecoderColumnHandle columnHandle;

    protected AbstractDateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
        this.value = value;
        this.columnHandle = columnHandle;
    }

    @Override
    public final boolean isNull() {
        return this.value.isMissingNode() || this.value.isNull();
    }

    @Override
    public final long getLong() {
        long millis = this.getMillis();
        Type type = this.columnHandle.getType();
        if (!(type != TimeType.TIME && type != TimeWithTimeZoneType.TIME_WITH_TIME_ZONE || millis >= 0L && millis < TimeUnit.DAYS.toMillis(1L))) {
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
        }
        if (type.equals(DateType.DATE)) {
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        if (type.equals(TimestampType.TIMESTAMP) || type.equals(TimeType.TIME)) {
            return millis;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return DateTimeEncoding.packDateTimeWithZone((long)millis, (int)0);
        }
        return millis;
    }

    protected abstract long getMillis();
}

