/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.json.JsonFieldDecoder;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SecondsSinceEpochJsonFieldDecoder
extends JsonFieldDecoder {
    @VisibleForTesting
    static final String NAME = "seconds-since-epoch";
    @VisibleForTesting
    static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withLocale(Locale.ENGLISH).withZoneUTC();

    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Long.TYPE, Slice.class);
    }

    @Override
    public String getFieldDecoderName() {
        return NAME;
    }

    @Override
    public FieldValueProvider decode(JsonNode value, DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Objects.requireNonNull(value, "value is null");
        return new SecondsSinceEpochJsonValueProvider(value, columnHandle);
    }

    public static class SecondsSinceEpochJsonValueProvider
    extends JsonFieldDecoder.DateTimeJsonValueProvider {
        public SecondsSinceEpochJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        protected long getMillis() {
            return this.isNull() ? 0L : this.value.asLong() * 1000L;
        }

        @Override
        public Slice getSlice() {
            return this.isNull() ? Slices.EMPTY_SLICE : Slices.utf8Slice((String)FORMATTER.print(this.value.asLong() * 1000L));
        }
    }
}

