/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.json;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class JsonFieldDecoder
implements FieldDecoder<JsonNode> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public final String getRowDecoderName() {
        return "json";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public FieldValueProvider decode(JsonNode value, DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Objects.requireNonNull(value, "value is null");
        return new JsonValueProvider(value, columnHandle);
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }

    public static abstract class DateTimeJsonValueProvider
    extends JsonValueProvider {
        protected DateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            super(value, columnHandle);
        }

        @Override
        public boolean getBoolean() {
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, "conversion to boolean not supported");
        }

        @Override
        public double getDouble() {
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, "conversion to double not supported");
        }

        @Override
        public final long getLong() {
            long millis = this.getMillis();
            Type type = this.columnHandle.getType();
            if (type.equals(DateType.DATE)) {
                return TimeUnit.MILLISECONDS.toDays(millis);
            }
            if (type.equals(TimestampType.TIMESTAMP) || type.equals(TimeType.TIME)) {
                return millis;
            }
            if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
                return DateTimeEncoding.packDateTimeWithZone((long)millis, (int)0);
            }
            return millis;
        }

        protected abstract long getMillis();
    }

    public static class JsonValueProvider
    extends FieldValueProvider {
        protected final JsonNode value;
        protected final DecoderColumnHandle columnHandle;

        public JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            this.value = value;
            this.columnHandle = columnHandle;
        }

        @Override
        public final boolean accept(DecoderColumnHandle columnHandle) {
            return this.columnHandle.equals(columnHandle);
        }

        @Override
        public final boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        @Override
        public boolean getBoolean() {
            return this.value.asBoolean();
        }

        @Override
        public long getLong() {
            return this.value.asLong();
        }

        @Override
        public double getDouble() {
            return this.value.asDouble();
        }

        @Override
        public Slice getSlice() {
            String textValue;
            String string = textValue = this.value.isValueNode() ? this.value.asText() : this.value.toString();
            if (this.isNull()) {
                return Slices.EMPTY_SLICE;
            }
            Slice slice = Slices.utf8Slice((String)textValue);
            if (Varchars.isVarcharType((Type)this.columnHandle.getType())) {
                slice = Varchars.truncateToLength((Slice)slice, (Type)this.columnHandle.getType());
            }
            return slice;
        }
    }
}

