/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder;

import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.RowDecoder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DecoderRegistry {
    private static final Logger log = Logger.get(DecoderRegistry.class);
    private final Map<String, RowDecoder> rowDecoders;
    private final Map<String, SetMultimap<Class<?>, FieldDecoder<?>>> fieldDecoders;

    @Inject
    DecoderRegistry(Set<RowDecoder> rowDecoders, Set<FieldDecoder<?>> fieldDecoders) {
        Objects.requireNonNull(rowDecoders, "rowDecoders is null");
        ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
        for (RowDecoder rowDecoder : rowDecoders) {
            rowBuilder.put((Object)rowDecoder.getName(), (Object)rowDecoder);
        }
        this.rowDecoders = rowBuilder.build();
        HashMap<String, ImmutableSetMultimap.Builder> fieldDecoderBuilders = new HashMap<String, ImmutableSetMultimap.Builder>();
        for (FieldDecoder<?> fieldDecoder : fieldDecoders) {
            ImmutableSetMultimap.Builder fieldDecoderBuilder = (ImmutableSetMultimap.Builder)fieldDecoderBuilders.get(fieldDecoder.getRowDecoderName());
            if (fieldDecoderBuilder == null) {
                fieldDecoderBuilder = ImmutableSetMultimap.builder();
                fieldDecoderBuilders.put(fieldDecoder.getRowDecoderName(), fieldDecoderBuilder);
            }
            for (Class<?> clazz : fieldDecoder.getJavaTypes()) {
                fieldDecoderBuilder.put(clazz, fieldDecoder);
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : fieldDecoderBuilders.entrySet()) {
            builder.put(entry.getKey(), (Object)((ImmutableSetMultimap.Builder)entry.getValue()).build());
        }
        this.fieldDecoders = builder.build();
        log.debug("Field decoders found: %s", new Object[]{this.fieldDecoders});
    }

    public RowDecoder getRowDecoder(String dataFormat) {
        Preconditions.checkState((boolean)this.rowDecoders.containsKey(dataFormat), (String)"no row decoder for '%s' found", (Object)dataFormat);
        return this.rowDecoders.get(dataFormat);
    }

    public FieldDecoder<?> getFieldDecoder(String rowDataFormat, Class<?> fieldType, @Nullable String fieldDataFormat) {
        Objects.requireNonNull(rowDataFormat, "rowDataFormat is null");
        Objects.requireNonNull(fieldType, "fieldType is null");
        Preconditions.checkState((boolean)this.fieldDecoders.containsKey(rowDataFormat), (String)"no field decoders for '%s' found", (Object)rowDataFormat);
        Set decoders = this.fieldDecoders.get(rowDataFormat).get(fieldType);
        ImmutableSet fieldNames = ImmutableSet.of((Object)MoreObjects.firstNonNull((Object)fieldDataFormat, (Object)"_default"), (Object)"_default");
        for (String fieldName : fieldNames) {
            for (FieldDecoder decoder : decoders) {
                if (!fieldName.equals(decoder.getFieldDecoderName())) continue;
                return decoder;
            }
        }
        throw new IllegalStateException(String.format("No field decoder for %s/%s found!", rowDataFormat, fieldType));
    }
}

