/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.csv;

import au.com.bytecode.opencsv.CSVParser;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.RowDecoder;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class CsvRowDecoder
implements RowDecoder {
    public static final String NAME = "csv";
    private final CSVParser parser = new CSVParser();

    @Inject
    CsvRowDecoder() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean decodeRow(byte[] data, Map<String, String> dataMap, Set<FieldValueProvider> fieldValueProviders, List<DecoderColumnHandle> columnHandles, Map<DecoderColumnHandle, FieldDecoder<?>> fieldDecoders) {
        String[] fields;
        try {
            String line = new String(data, StandardCharsets.UTF_8);
            fields = this.parser.parseLine(line);
        }
        catch (Exception e) {
            return true;
        }
        for (DecoderColumnHandle columnHandle : columnHandles) {
            FieldDecoder<?> decoder;
            if (columnHandle.isInternal()) continue;
            String mapping = columnHandle.getMapping();
            Preconditions.checkState((mapping != null ? 1 : 0) != 0, (String)"No mapping for column handle %s!", (Object)columnHandle);
            int columnIndex = Integer.parseInt(mapping);
            if (columnIndex >= fields.length || (decoder = fieldDecoders.get(columnHandle)) == null) continue;
            fieldValueProviders.add(decoder.decode(fields[columnIndex], columnHandle));
        }
        return false;
    }
}

