/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.dummy;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.util.Objects;
import java.util.Set;

public class DummyFieldDecoder
implements FieldDecoder<Void> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public final String getRowDecoderName() {
        return "dummy";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public FieldValueProvider decode(Void value, DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        return new FieldValueProvider(){

            @Override
            public boolean accept(DecoderColumnHandle handle) {
                return false;
            }

            @Override
            public boolean isNull() {
                throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, "is null check not supported");
            }
        };
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

