/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.csv;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Set;

public class CsvFieldDecoder
implements FieldDecoder<String> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public String getRowDecoderName() {
        return "csv";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public FieldValueProvider decode(final String value, final DecoderColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        return new FieldValueProvider(){

            @Override
            public boolean accept(DecoderColumnHandle handle) {
                return columnHandle.equals(handle);
            }

            @Override
            public boolean isNull() {
                return value == null || value.isEmpty();
            }

            @Override
            public boolean getBoolean() {
                return this.isNull() ? false : Boolean.parseBoolean(value.trim());
            }

            @Override
            public long getLong() {
                return this.isNull() ? 0L : Long.parseLong(value.trim());
            }

            @Override
            public double getDouble() {
                return this.isNull() ? 0.0 : Double.parseDouble(value.trim());
            }

            @Override
            public Slice getSlice() {
                if (this.isNull()) {
                    return Slices.EMPTY_SLICE;
                }
                Slice slice = Slices.utf8Slice((String)value);
                if (Varchars.isVarcharType((Type)columnHandle.getType())) {
                    slice = Varchars.truncateToLength((Slice)slice, (Type)columnHandle.getType());
                }
                return slice;
            }
        };
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }
}

