/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.decoder.raw;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.DecoderErrorCode;
import com.facebook.presto.decoder.FieldDecoder;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class RawFieldDecoder
implements FieldDecoder<byte[]> {
    @Override
    public Set<Class<?>> getJavaTypes() {
        return ImmutableSet.of(Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class);
    }

    @Override
    public final String getRowDecoderName() {
        return "raw";
    }

    @Override
    public String getFieldDecoderName() {
        return "_default";
    }

    @Override
    public FieldValueProvider decode(byte[] value, DecoderColumnHandle columnHandle) {
        ImmutableList fields;
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Objects.requireNonNull(value, "value is null");
        String mapping = columnHandle.getMapping();
        FieldType fieldType = columnHandle.getDataFormat() == null ? FieldType.BYTE : FieldType.forString(columnHandle.getDataFormat());
        int start = 0;
        int end = value.length;
        if (mapping != null && !(fields = ImmutableList.copyOf((Iterable)Splitter.on((char)':').limit(2).split((CharSequence)mapping))).isEmpty()) {
            start = Integer.parseInt((String)fields.get(0));
            Preconditions.checkState((start >= 0 && start < value.length ? 1 : 0) != 0, (String)"Found start %s, but only 0..%s is legal", (Object[])new Object[]{start, value.length});
            if (fields.size() > 1) {
                end = Integer.parseInt((String)fields.get(1));
                Preconditions.checkState((end > 0 && end <= value.length ? 1 : 0) != 0, (String)"Found end %s, but only 1..%s is legal", (Object[])new Object[]{end, value.length});
            }
        }
        Preconditions.checkState((start <= end ? 1 : 0) != 0, (String)"Found start %s and end %s. start must be smaller than end", (Object[])new Object[]{start, end});
        return new RawValueProvider(ByteBuffer.wrap(value, start, end - start), columnHandle, fieldType);
    }

    public String toString() {
        return String.format("FieldDecoder[%s/%s]", this.getRowDecoderName(), this.getFieldDecoderName());
    }

    public static class RawValueProvider
    extends FieldValueProvider {
        protected final ByteBuffer value;
        protected final DecoderColumnHandle columnHandle;
        protected final FieldType fieldType;
        protected final int size;

        public RawValueProvider(ByteBuffer value, DecoderColumnHandle columnHandle, FieldType fieldType) {
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.fieldType = Objects.requireNonNull(fieldType, "fieldType is null");
            this.size = value.limit() - value.position();
            if (this.size > 0) {
                Preconditions.checkState((this.size >= fieldType.getSize() ? 1 : 0) != 0, (String)"minimum byte size is %s, found %s,", (Object[])new Object[]{fieldType.getSize(), this.size});
            }
            this.value = value;
        }

        @Override
        public final boolean accept(DecoderColumnHandle columnHandle) {
            return this.columnHandle.equals(columnHandle);
        }

        @Override
        public final boolean isNull() {
            return this.size == 0;
        }

        @Override
        public boolean getBoolean() {
            if (this.isNull()) {
                return false;
            }
            switch (this.fieldType) {
                case BYTE: {
                    return this.value.get() != 0;
                }
                case SHORT: {
                    return this.value.getShort() != 0;
                }
                case INT: {
                    return this.value.getInt() != 0;
                }
                case LONG: {
                    return this.value.getLong() != 0L;
                }
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("conversion %s to boolean not supported", new Object[]{this.fieldType}));
        }

        @Override
        public long getLong() {
            if (this.isNull()) {
                return 0L;
            }
            switch (this.fieldType) {
                case BYTE: {
                    return this.value.get();
                }
                case SHORT: {
                    return this.value.getShort();
                }
                case INT: {
                    return this.value.getInt();
                }
                case LONG: {
                    return this.value.getLong();
                }
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("conversion %s to long not supported", new Object[]{this.fieldType}));
        }

        @Override
        public double getDouble() {
            if (this.isNull()) {
                return 0.0;
            }
            switch (this.fieldType) {
                case FLOAT: {
                    return this.value.getFloat();
                }
                case DOUBLE: {
                    return this.value.getDouble();
                }
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("conversion %s to double not supported", new Object[]{this.fieldType}));
        }

        @Override
        public Slice getSlice() {
            if (this.isNull()) {
                return Slices.EMPTY_SLICE;
            }
            if (this.fieldType == FieldType.BYTE) {
                Slice slice = Slices.wrappedBuffer((ByteBuffer)this.value.slice());
                if (Varchars.isVarcharType((Type)this.columnHandle.getType())) {
                    slice = Varchars.truncateToLength((Slice)slice, (Type)this.columnHandle.getType());
                }
                return slice;
            }
            throw new PrestoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("conversion %s to Slice not supported", new Object[]{this.fieldType}));
        }
    }

    public static enum FieldType {
        BYTE(8),
        SHORT(16),
        INT(32),
        LONG(64),
        FLOAT(32),
        DOUBLE(64);

        private final int size;

        private FieldType(int bitSize) {
            this.size = bitSize / 8;
        }

        public int getSize() {
            return this.size;
        }

        static FieldType forString(String value) {
            if (value != null) {
                for (FieldType fieldType : FieldType.values()) {
                    if (!value.toUpperCase(Locale.ENGLISH).equals(fieldType.name())) continue;
                    return fieldType;
                }
            }
            return null;
        }
    }
}

