/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.proxy;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import java.io.File;

public class JwtHandlerConfig {
    private File jwtKeyFile;
    private String jwtKeyFilePassword;
    private String jwtKeyId;
    private String jwtIssuer;
    private String jwtAudience;

    public File getJwtKeyFile() {
        return this.jwtKeyFile;
    }

    @Config(value="jwt.key-file")
    @ConfigDescription(value="Key file used for generating JWT signatures")
    public JwtHandlerConfig setJwtKeyFile(File jwtKeyFile) {
        this.jwtKeyFile = jwtKeyFile;
        return this;
    }

    public String getJwtKeyFilePassword() {
        return this.jwtKeyFilePassword;
    }

    @Config(value="jwt.key-file-password")
    @ConfigDescription(value="Password for encrypted key file")
    @ConfigSecuritySensitive
    public JwtHandlerConfig setJwtKeyFilePassword(String jwtKeyFilePassword) {
        this.jwtKeyFilePassword = jwtKeyFilePassword;
        return this;
    }

    public String getJwtKeyId() {
        return this.jwtKeyId;
    }

    @Config(value="jwt.key-id")
    @ConfigDescription(value="Key ID for JWT")
    public JwtHandlerConfig setJwtKeyId(String jwtKeyId) {
        this.jwtKeyId = jwtKeyId;
        return this;
    }

    public String getJwtIssuer() {
        return this.jwtIssuer;
    }

    @Config(value="jwt.issuer")
    @ConfigDescription(value="Issuer for JWT")
    public JwtHandlerConfig setJwtIssuer(String jwtIssuer) {
        this.jwtIssuer = jwtIssuer;
        return this;
    }

    public String getJwtAudience() {
        return this.jwtAudience;
    }

    @Config(value="jwt.audience")
    @ConfigDescription(value="Audience for JWT")
    public JwtHandlerConfig setJwtAudience(String jwtAudience) {
        this.jwtAudience = jwtAudience;
        return this;
    }
}

