/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.postgresql;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.QueryBuilder;
import com.facebook.presto.plugin.jdbc.mapping.ReadMapping;
import com.facebook.presto.plugin.jdbc.mapping.StandardColumnMappings;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class PostgreSqlClient
extends BaseJdbcClient {
    protected final Type jsonType;
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private final Type uuidType;
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)new JsonFactoryBuilder().configure(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES, false)).build();
    private static final ObjectMapper SORTED_MAPPER = new JsonObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    @Inject
    public PostgreSqlClient(JdbcConnectorId connectorId, BaseJdbcConfig config, TypeManager typeManager) {
        super(connectorId, config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new org.postgresql.Driver(), config));
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
    }

    public PreparedStatement getPreparedStatement(ConnectorSession session, Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getTables(connection.getCatalog(), PostgreSqlClient.escapeNamePattern(schemaName, escape).orElse(null), PostgreSqlClient.escapeNamePattern(tableName, escape).orElse(null), new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE", "PARTITIONED TABLE"});
    }

    protected String toSqlType(Type type) {
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return "bytea";
        }
        return super.toSqlType(type);
    }

    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, List<JdbcColumnHandle> columnHandles) throws SQLException {
        Map columnExpressions = (Map)columnHandles.stream().filter(handle -> handle.getJdbcTypeHandle().getJdbcTypeName().equalsIgnoreCase("Geometry")).map(JdbcColumnHandle::getColumnName).collect(ImmutableMap.toImmutableMap(Function.identity(), columnName -> "ST_AsBinary(" + QueryBuilder.quote((String)this.identifierQuote, (String)columnName) + ")"));
        return new QueryBuilder(this.identifierQuote).buildSql((JdbcClient)this, session, connection, split.getCatalogName(), split.getSchemaName(), split.getTableName(), columnHandles, columnExpressions, split.getTupleDomain(), split.getAdditionalPredicate());
    }

    public Optional<ReadMapping> toPrestoType(ConnectorSession session, JdbcTypeHandle typeHandle) {
        String typeName = typeHandle.getJdbcTypeName();
        if (typeHandle.getJdbcTypeName().equals("jsonb") || typeHandle.getJdbcTypeName().equals("json")) {
            return Optional.of(this.jsonReadMapping());
        }
        if (typeHandle.getJdbcTypeName().equals("uuid")) {
            return Optional.of(this.uuidReadMapping());
        }
        if (typeName.equalsIgnoreCase("Geometry") || typeName.equalsIgnoreCase("SphericalGeography")) {
            return Optional.of(StandardColumnMappings.geometryReadMapping());
        }
        return super.toPrestoType(session, typeHandle);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(tableMetadata, session, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            if (DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, oldTable.getSchemaName(), oldTable.getTableName()), this.quoted(newTable.getTableName()));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ReadMapping jsonReadMapping() {
        return ReadMapping.createSliceReadMapping((Type)this.jsonType, (resultSet, columnIndex) -> PostgreSqlClient.jsonParse(Slices.utf8Slice((String)resultSet.getString(columnIndex))));
    }

    public static Slice jsonParse(Slice slice) {
        Slice slice2;
        block8: {
            JsonParser parser = PostgreSqlClient.createJsonParser(JSON_FACTORY, slice);
            try {
                byte[] in = slice.getBytes();
                DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(in.length);
                SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(parser, Object.class));
                parser.nextToken();
                slice2 = dynamicSliceOutput.slice();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert '%s' to JSON", slice.toStringUtf8()));
                }
            }
            parser.close();
        }
        return slice2;
    }

    public static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }

    private ReadMapping uuidReadMapping() {
        return ReadMapping.createSliceReadMapping((Type)this.uuidType, (resultSet, columnIndex) -> PostgreSqlClient.uuidSlice((UUID)resultSet.getObject(columnIndex)));
    }

    private static Slice uuidSlice(UUID uuid) {
        return Slices.wrappedLongArray((long[])new long[]{Long.reverseBytes(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits())});
    }

    public String normalizeIdentifier(ConnectorSession session, String identifier) {
        return this.caseSensitiveNameMatchingEnabled ? identifier : identifier.toLowerCase(Locale.ENGLISH);
    }
}

