/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingConnectorAccessControl
implements ConnectorAccessControl {
    public static ConnectorAccessControl of(final Supplier<ConnectorAccessControl> connectorAccessControlSupplier) {
        Objects.requireNonNull(connectorAccessControlSupplier, "connectorAccessControlSupplier is null");
        return new ForwardingConnectorAccessControl(){

            @Override
            protected ConnectorAccessControl delegate() {
                return (ConnectorAccessControl)connectorAccessControlSupplier.get();
            }
        };
    }

    protected abstract ConnectorAccessControl delegate();

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        this.delegate().checkCanCreateSchema(transactionHandle, identity, context, schemaName);
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        this.delegate().checkCanDropSchema(transactionHandle, identity, context, schemaName);
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(transactionHandle, identity, context, schemaName, newSchemaName);
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context) {
        this.delegate().checkCanShowSchemas(transactionHandle, identity, context);
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> schemaNames) {
        return this.delegate().filterSchemas(transactionHandle, identity, context, schemaNames);
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanCreateTable(transactionHandle, identity, context, tableName);
    }

    public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanDropTable(transactionHandle, identity, context, tableName);
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        this.delegate().checkCanRenameTable(transactionHandle, identity, context, tableName, newTableName);
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        this.delegate().checkCanShowTablesMetadata(transactionHandle, identity, context, schemaName);
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(transactionHandle, identity, context, tableNames);
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanAddColumn(transactionHandle, identity, context, tableName);
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanDropColumn(transactionHandle, identity, context, tableName);
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanRenameColumn(transactionHandle, identity, context, tableName);
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<Subfield> columnOrSubfieldNames) {
        this.delegate().checkCanSelectFromColumns(transactionHandle, identity, context, tableName, columnOrSubfieldNames);
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanInsertIntoTable(transactionHandle, identity, context, tableName);
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanDeleteFromTable(transactionHandle, identity, context, tableName);
    }

    public void checkCanTruncateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        this.delegate().checkCanTruncateTable(transactionHandle, identity, context, tableName);
    }

    public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        this.delegate().checkCanCreateView(transactionHandle, identity, context, viewName);
    }

    public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        this.delegate().checkCanDropView(transactionHandle, identity, context, viewName);
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(transactionHandle, identity, context, tableName, columnNames);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(transactionHandle, identity, context, propertyName);
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, context, privilege, tableName, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, context, privilege, tableName, revokee, grantOptionFor);
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role, Optional<PrestoPrincipal> grantor) {
        this.delegate().checkCanCreateRole(transactionHandle, identity, context, role, grantor);
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role) {
        this.delegate().checkCanDropRole(transactionHandle, identity, context, role);
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanGrantRoles(transactionHandle, identity, context, roles, grantees, withAdminOption, grantor, catalogName);
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanRevokeRoles(transactionHandle, identity, context, roles, grantees, adminOptionFor, grantor, catalogName);
    }

    public void checkCanSetRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role, String catalogName) {
        this.delegate().checkCanSetRole(transactionHandle, identity, context, role, catalogName);
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
        this.delegate().checkCanShowRoles(transactionHandle, identity, context, catalogName);
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
        this.delegate().checkCanShowCurrentRoles(transactionHandle, identity, context, catalogName);
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
        this.delegate().checkCanShowRoleGrants(transactionHandle, identity, context, catalogName);
    }
}

