/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.plugin.base.JsonUtils;
import com.facebook.presto.plugin.base.security.AccessControlRules;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlConfig;
import com.facebook.presto.plugin.base.security.SchemaAccessControlRule;
import com.facebook.presto.plugin.base.security.SessionPropertyAccessControlRule;
import com.facebook.presto.plugin.base.security.TableAccessControlRule;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class FileBasedAccessControl
implements ConnectorAccessControl {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final List<SchemaAccessControlRule> schemaRules;
    private final List<TableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;

    @Inject
    public FileBasedAccessControl(FileBasedAccessControlConfig config) {
        AccessControlRules rules = JsonUtils.parseJson(Paths.get(config.getConfigFile(), new String[0]), AccessControlRules.class);
        this.schemaRules = rules.getSchemaRules();
        this.tableRules = rules.getTableRules();
        this.sessionPropertyRules = rules.getSessionPropertyRules();
    }

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        AccessDeniedException.denyCreateSchema((String)schemaName);
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
        AccessDeniedException.denyDropSchema((String)schemaName);
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName, String newSchemaName) {
        AccessDeniedException.denyRenameSchema((String)schemaName, (String)newSchemaName);
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context) {
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.isDatabaseOwner(identity, tableName.getSchemaName())) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String schemaName) {
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<Subfield> columnOrSubfieldNames) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
    }

    public void checkCanTruncateTable(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        if (!this.isDatabaseOwner(identity, viewName.getSchemaName())) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, SchemaTableName viewName) {
        if (!this.checkTablePermission(identity, viewName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, SchemaTableName tableName, Set<String> columnNames) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.SELECT)) {
            AccessDeniedException.denySelectTable((String)tableName.toString());
        }
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (ConnectorIdentity)identity);
        }
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String propertyName) {
        if (!this.canSetSessionProperty(identity, propertyName)) {
            FileBasedAccessControl.denySetSessionProperty(propertyName);
        }
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, ConnectorIdentity identity, AccessControlContext context, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        if (!this.checkTablePermission(identity, tableName, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
        }
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role, Optional<PrestoPrincipal> grantor) {
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role) {
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
    }

    public void checkCanSetRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String role, String catalogName) {
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, AccessControlContext context, String catalogName) {
    }

    private boolean canSetSessionProperty(ConnectorIdentity identity, String property) {
        for (SessionPropertyAccessControlRule rule : this.sessionPropertyRules) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), property);
            if (allowed.isPresent() && allowed.get().booleanValue()) {
                return true;
            }
            if (!allowed.isPresent() || allowed.get().booleanValue()) continue;
            return false;
        }
        return false;
    }

    private boolean checkTablePermission(ConnectorIdentity identity, SchemaTableName tableName, TableAccessControlRule.TablePrivilege ... requiredPrivileges) {
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return true;
        }
        for (TableAccessControlRule rule : this.tableRules) {
            Optional<Set<TableAccessControlRule.TablePrivilege>> tablePrivileges = rule.match(identity.getUser(), tableName);
            if (!tablePrivileges.isPresent()) continue;
            return tablePrivileges.get().containsAll((Collection<?>)ImmutableSet.copyOf((Object[])requiredPrivileges));
        }
        return false;
    }

    private boolean isDatabaseOwner(ConnectorIdentity identity, String schemaName) {
        for (SchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(identity.getUser(), schemaName);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }

    private static void denySetSessionProperty(String propertyName) {
        throw new AccessDeniedException("Cannot set catalog session property: " + propertyName);
    }
}

