/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingConnectorAccessControl
implements ConnectorAccessControl {
    public static ConnectorAccessControl of(final Supplier<ConnectorAccessControl> connectorAccessControlSupplier) {
        Objects.requireNonNull(connectorAccessControlSupplier, "connectorAccessControlSupplier is null");
        return new ForwardingConnectorAccessControl(){

            @Override
            protected ConnectorAccessControl delegate() {
                return (ConnectorAccessControl)connectorAccessControlSupplier.get();
            }
        };
    }

    protected abstract ConnectorAccessControl delegate();

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        this.delegate().checkCanCreateSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        this.delegate().checkCanDropSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(transactionHandle, identity, schemaName, newSchemaName);
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, Identity identity) {
        this.delegate().checkCanShowSchemas(transactionHandle, identity);
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, Identity identity, Set<String> schemaNames) {
        return this.delegate().filterSchemas(transactionHandle, identity, schemaNames);
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanCreateTable(transactionHandle, identity, tableName);
    }

    public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanDropTable(transactionHandle, identity, tableName);
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        this.delegate().checkCanRenameTable(transactionHandle, identity, tableName, newTableName);
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
        this.delegate().checkCanShowTablesMetadata(transactionHandle, identity, schemaName);
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, Identity identity, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(transactionHandle, identity, tableNames);
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanAddColumn(transactionHandle, identity, tableName);
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanDropColumn(transactionHandle, identity, tableName);
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanRenameColumn(transactionHandle, identity, tableName);
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanInsertIntoTable(transactionHandle, identity, tableName);
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
        this.delegate().checkCanDeleteFromTable(transactionHandle, identity, tableName);
    }

    public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        this.delegate().checkCanCreateView(transactionHandle, identity, viewName);
    }

    public void checkCanDropView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
        this.delegate().checkCanDropView(transactionHandle, identity, viewName);
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, Identity identity, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(transactionHandle, identity, propertyName);
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, privilege, tableName, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, privilege, tableName, revokee, grantOptionFor);
    }
}

