/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class Unnest
extends Relation {
    private final List<Expression> expressions;

    public Unnest(List<Expression> expressions) {
        Preconditions.checkNotNull(expressions, (Object)"expressions is null");
        this.expressions = ImmutableList.copyOf(expressions);
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public String toString() {
        return "UNNEST(" + Joiner.on((String)", ").join(this.expressions) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Unnest other = (Unnest)obj;
        return Objects.equals(this.expressions, other.expressions);
    }
}

