/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import javax.inject.Inject;

public final class Serialization {
    private Serialization() {
    }

    public static class FunctionCallDeserializer
    extends JsonDeserializer<FunctionCall> {
        private final SqlParser sqlParser;

        @Inject
        public FunctionCallDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public FunctionCall deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return (FunctionCall)this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class));
        }
    }

    public static class ExpressionDeserializer
    extends JsonDeserializer<Expression> {
        private final SqlParser sqlParser;

        @Inject
        public ExpressionDeserializer(SqlParser sqlParser) {
            this.sqlParser = sqlParser;
        }

        public Expression deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.sqlParser.createExpression((String)jsonParser.readValueAs(String.class));
        }
    }

    public static class ExpressionSerializer
    extends JsonSerializer<Expression> {
        public void serialize(Expression expression, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(ExpressionFormatter.formatExpression(expression));
        }
    }
}

