/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.parser.StatementBuilder;
import com.facebook.presto.sql.parser.StatementLexer;
import com.facebook.presto.sql.parser.StatementParser;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import javax.inject.Inject;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.BufferedTreeNodeStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeNodeStream;

public class SqlParser {
    private final EnumSet<IdentifierSymbol> allowedIdentifierSymbols;

    public SqlParser() {
        this(new SqlParserOptions());
    }

    @Inject
    public SqlParser(SqlParserOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"options is null");
        this.allowedIdentifierSymbols = EnumSet.copyOf(options.getAllowedIdentifierSymbols());
    }

    public Statement createStatement(String sql) {
        try {
            return this.createStatement(this.parseStatement(sql));
        }
        catch (StackOverflowError e) {
            throw new ParsingException("statement is too large (stack overflow while parsing)");
        }
    }

    public Expression createExpression(String expression) {
        try {
            return this.createExpression(this.parseExpression(expression));
        }
        catch (StackOverflowError e) {
            throw new ParsingException("expression is too large (stack overflow while parsing)");
        }
    }

    @VisibleForTesting
    Statement createStatement(CommonTree tree) {
        BufferedTreeNodeStream stream = new BufferedTreeNodeStream((Object)tree);
        StatementBuilder builder = new StatementBuilder((TreeNodeStream)stream);
        try {
            return builder.statement().value;
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Expression createExpression(CommonTree tree) {
        BufferedTreeNodeStream stream = new BufferedTreeNodeStream((Object)tree);
        StatementBuilder builder = new StatementBuilder((TreeNodeStream)stream);
        try {
            return builder.singleExpression().value;
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @VisibleForTesting
    CommonTree parseStatement(String sql) {
        try {
            return (CommonTree)this.getParser(sql).singleStatement().getTree();
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private CommonTree parseExpression(String expression) {
        try {
            return (CommonTree)this.getParser(expression).singleExpression().getTree();
        }
        catch (RecognitionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private StatementParser getParser(String sql) {
        CaseInsensitiveStream stream = new CaseInsensitiveStream((CharStream)new ANTLRStringStream(sql));
        StatementLexer lexer = new StatementLexer(stream);
        lexer.setAllowedIdentifierSymbols(this.allowedIdentifierSymbols);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        return new StatementParser((TokenStream)tokenStream);
    }
}

