/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.ParsingException;
import java.util.EnumSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;

public enum IdentifierSymbol {
    COLON(':'),
    AT_SIGN('@');

    private final char symbol;

    private IdentifierSymbol(char symbol) {
        this.symbol = symbol;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public static void validateIdentifier(IntStream input, String name, EnumSet<IdentifierSymbol> allowedSymbols) {
        for (IdentifierSymbol identifierSymbol : EnumSet.complementOf(allowedSymbols)) {
            char symbol = identifierSymbol.getSymbol();
            if (name.indexOf(symbol) < 0) continue;
            input.rewind();
            throw new ParsingException("identifiers must not contain '" + identifierSymbol.getSymbol() + "'", new RecognitionException(input));
        }
    }
}

