/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SetOperation;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Union
extends SetOperation {
    private final List<Relation> relations;
    private final boolean distinct;

    public Union(List<Relation> relations, boolean distinct) {
        Preconditions.checkNotNull(relations, (Object)"relations is null");
        this.relations = ImmutableList.copyOf(relations);
        this.distinct = distinct;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnion(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("relations", this.relations).add("distinct", this.distinct).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Union o = (Union)obj;
        return Objects.equal(this.relations, o.relations) && Objects.equal((Object)this.distinct, (Object)o.distinct);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relations, this.distinct});
    }
}

