/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public class Window
extends Node {
    private final List<Expression> partitionBy;
    private final List<SortItem> orderBy;
    private final Optional<WindowFrame> frame;

    public Window(List<Expression> partitionBy, List<SortItem> orderBy, WindowFrame frame) {
        this.partitionBy = (List)Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        this.orderBy = (List)Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        this.frame = Optional.fromNullable((Object)frame);
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<WindowFrame> getFrame() {
        return this.frame;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Window o = (Window)obj;
        return Objects.equal(this.partitionBy, o.partitionBy) && Objects.equal(this.orderBy, o.orderBy) && Objects.equal(this.frame, o.frame);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partitionBy, this.orderBy, this.frame});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("frame", this.frame).toString();
    }
}

