/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SelectItem;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class SingleColumn
extends SelectItem {
    private final Optional<String> alias;
    private final Expression expression;

    public SingleColumn(Expression expression, Optional<String> alias) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull(alias, (Object)"alias is null");
        this.expression = expression;
        this.alias = alias;
    }

    public SingleColumn(Expression expression, String alias) {
        this(expression, (Optional<String>)Optional.of((Object)alias));
    }

    public SingleColumn(Expression expression) {
        this(expression, (Optional<String>)Optional.absent());
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equal(this.alias, other.alias) && Objects.equal((Object)this.expression, (Object)other.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alias, this.expression});
    }

    @Override
    public String toString() {
        if (this.alias.isPresent()) {
            return this.expression.toString() + " " + (String)this.alias.get();
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }
}

