/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class Join
extends Relation {
    private final Type type;
    private final Relation left;
    private final Relation right;
    private final JoinCriteria criteria;

    public Join(Type type, Relation left, Relation right, JoinCriteria criteria) {
        Preconditions.checkNotNull((Object)left, (Object)"left is null");
        Preconditions.checkNotNull((Object)right, (Object)"right is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = criteria;
    }

    public Type getType() {
        return this.type;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public JoinCriteria getCriteria() {
        return this.criteria;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("left", (Object)this.left).add("right", (Object)this.right).add("criteria", (Object)this.criteria).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        if (this.criteria != null ? !this.criteria.equals(join.criteria) : join.criteria != null) {
            return false;
        }
        if (!this.left.equals(join.left)) {
            return false;
        }
        if (!this.right.equals(join.right)) {
            return false;
        }
        return this.type == join.type;
    }

    @Override
    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        result = 31 * result + (this.criteria != null ? this.criteria.hashCode() : 0);
        return result;
    }

    public static enum Type {
        CROSS,
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

