/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Descriptor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableFunctionDescriptorArgument
extends Node {
    private final Optional<Descriptor> descriptor;

    public static TableFunctionDescriptorArgument descriptorArgument(NodeLocation location, Descriptor descriptor) {
        Objects.requireNonNull(descriptor, "descriptor is null");
        return new TableFunctionDescriptorArgument(location, Optional.of(descriptor));
    }

    public static TableFunctionDescriptorArgument nullDescriptorArgument(NodeLocation location) {
        return new TableFunctionDescriptorArgument(location, Optional.empty());
    }

    private TableFunctionDescriptorArgument(NodeLocation location, Optional<Descriptor> descriptor) {
        super(Optional.of(location));
        this.descriptor = descriptor;
    }

    public Optional<Descriptor> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDescriptorArgument(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return (List)this.descriptor.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.descriptor, ((TableFunctionDescriptorArgument)o).descriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.descriptor);
    }

    @Override
    public String toString() {
        return this.descriptor.map(Descriptor::toString).orElse("CAST (NULL AS DESCRIPTOR)");
    }

    @Override
    public String getArgumentTypeString() {
        return "descriptor";
    }
}

