/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RefreshMaterializedView
extends Statement {
    private final Table target;
    private final Optional<Expression> where;

    public RefreshMaterializedView(Table target, Optional<Expression> where) {
        this(Optional.empty(), target, where);
    }

    public RefreshMaterializedView(NodeLocation location, Table target, Optional<Expression> where) {
        this(Optional.of(location), target, where);
    }

    private RefreshMaterializedView(Optional<NodeLocation> location, Table target, Optional<Expression> where) {
        super(location);
        this.target = Objects.requireNonNull(target, "target is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTarget() {
        return this.target;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRefreshMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.target);
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("REFRESH MATERIALIZED VIEW", this.target.getName().toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.where);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RefreshMaterializedView o = (RefreshMaterializedView)obj;
        return Objects.equals(this.target, o.target) && Objects.equals(this.where, o.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.target).add("where", this.where).toString();
    }
}

