/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.MergeCase;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Merge
extends Statement {
    private final Relation target;
    private final Relation source;
    private final Expression predicate;
    private final List<MergeCase> mergeCases;

    public Merge(NodeLocation location, Relation target, Relation source, Expression predicate, List<MergeCase> mergeCases) {
        this(Optional.of(location), target, source, predicate, mergeCases);
    }

    public Merge(Optional<NodeLocation> location, Relation target, Relation source, Expression predicate, List<MergeCase> mergeCases) {
        super(location);
        this.target = Objects.requireNonNull(target, "target is null");
        Preconditions.checkArgument((target instanceof Table || target instanceof AliasedRelation ? 1 : 0) != 0, (String)"target (%s) is neither a Table nor an AliasedRelation", (Object)target);
        this.source = Objects.requireNonNull(source, "source is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.mergeCases = ImmutableList.copyOf((Collection)Objects.requireNonNull(mergeCases, "mergeCases is null"));
    }

    public Relation getTarget() {
        return this.target;
    }

    public Relation getSource() {
        return this.source;
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public List<MergeCase> getMergeCases() {
        return this.mergeCases;
    }

    public Table getTargetTable() {
        if (this.target instanceof Table) {
            return (Table)this.target;
        }
        Preconditions.checkArgument((boolean)(this.target instanceof AliasedRelation), (Object)"MERGE relation is neither a Table nor an AliasedRelation");
        return (Table)((AliasedRelation)this.target).getRelation();
    }

    public Optional<Identifier> getTargetAlias() {
        if (this.target instanceof AliasedRelation) {
            return Optional.of(((AliasedRelation)this.target).getAlias());
        }
        return Optional.empty();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMerge(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.target);
        builder.add((Object)this.source);
        builder.add((Object)this.predicate);
        builder.addAll(this.mergeCases);
        return builder.build();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("MERGE", this.target.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Merge merge = (Merge)o;
        return Objects.equals(this.target, merge.target) && Objects.equals(this.source, merge.source) && Objects.equals(this.predicate, merge.predicate) && Objects.equals(this.mergeCases, merge.mergeCases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, this.source, this.predicate, this.mergeCases);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("relation", (Object)this.source).add("predicate", (Object)this.predicate).add("mergeCases", this.mergeCases).omitNullValues().toString();
    }
}

