/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.TableElement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTable
extends Statement {
    private final QualifiedName name;
    private final List<TableElement> elements;
    private final boolean notExists;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateTable(QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        this(Optional.empty(), name, elements, notExists, properties, comment);
    }

    public CreateTable(NodeLocation location, QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        this(Optional.of(location), name, elements, notExists, properties, comment);
    }

    private CreateTable(Optional<NodeLocation> location, QualifiedName name, List<TableElement> elements, boolean notExists, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "table is null");
        this.elements = ImmutableList.copyOf((Collection)Objects.requireNonNull(elements, "elements is null"));
        this.notExists = notExists;
        this.properties = Objects.requireNonNull(properties, "properties is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<TableElement> getElements() {
        return this.elements;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.elements).addAll(this.properties).build();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("CREATE TABLE", this.name.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.elements, this.notExists, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTable o = (CreateTable)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.elements, o.elements) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("elements", this.elements).add("notExists", this.notExists).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

