/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Analyze
extends Statement {
    private final QualifiedName tableName;
    private final List<Property> properties;

    public Analyze(QualifiedName tableName, List<Property> properties) {
        this(Optional.empty(), tableName, properties);
    }

    public Analyze(NodeLocation location, QualifiedName tableName, List<Property> properties) {
        this(Optional.of(location), tableName, properties);
    }

    private Analyze(Optional<NodeLocation> location, QualifiedName tableName, List<Property> properties) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "table is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAnalyze(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.properties);
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("ANALYZE", this.tableName.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Analyze o = (Analyze)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.properties, o.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("properties", this.properties).toString();
    }
}

