/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.spi.analyzer.UpdateInfo;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AlterColumnNotNull
extends Statement {
    private final QualifiedName table;
    private final Identifier column;
    private final boolean tableExists;
    private final boolean dropConstraint;

    public AlterColumnNotNull(QualifiedName table, Identifier column, boolean tableExists, boolean dropConstraint) {
        this(Optional.empty(), table, column, tableExists, dropConstraint);
    }

    public AlterColumnNotNull(NodeLocation location, QualifiedName table, Identifier column, boolean tableExists, boolean dropConstraint) {
        this(Optional.of(location), table, column, tableExists, dropConstraint);
    }

    private AlterColumnNotNull(Optional<NodeLocation> location, QualifiedName table, Identifier column, boolean tableExists, boolean dropConstraint) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableExists = tableExists;
        this.dropConstraint = dropConstraint;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Identifier getColumn() {
        return this.column;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isDropConstraint() {
        return this.dropConstraint;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterColumnNotNull(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public UpdateInfo getUpdateInfo() {
        return new UpdateInfo("ALTER COLUMN NOT NULL", this.table.getSuffix());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterColumnNotNull that = (AlterColumnNotNull)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.column, that.column) && Objects.equals(this.tableExists, that.tableExists) && Objects.equals(this.dropConstraint, that.dropConstraint);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.column, this.tableExists, this.dropConstraint);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("column", (Object)this.column).add("tableExists", this.tableExists).add("dropConstraint", this.dropConstraint).toString();
    }
}

