/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DereferenceExpression
extends Expression {
    private final Expression base;
    private final Identifier field;

    public DereferenceExpression(Expression base, Identifier field) {
        this(Optional.empty(), base, field);
    }

    public DereferenceExpression(NodeLocation location, Expression base, Identifier field) {
        this(Optional.of(location), base, field);
    }

    private DereferenceExpression(Optional<NodeLocation> location, Expression base, Identifier field) {
        super(location);
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"base is null");
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"fieldName is null");
        this.base = base;
        this.field = field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.base);
    }

    public Expression getBase() {
        return this.base;
    }

    public Identifier getField() {
        return this.field;
    }

    public static QualifiedName getQualifiedName(DereferenceExpression expression) {
        QualifiedName baseQualifiedName;
        ImmutableList parts = null;
        if (expression.base instanceof Identifier) {
            parts = ImmutableList.of((Object)((Identifier)expression.base), (Object)expression.field);
        } else if (expression.base instanceof DereferenceExpression && (baseQualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)expression.base)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(baseQualifiedName.getOriginalParts());
            builder.add((Object)expression.field);
            parts = builder.build();
        }
        return parts == null ? null : QualifiedName.of((Iterable<Identifier>)parts);
    }

    public static Expression from(QualifiedName name) {
        Expression result = null;
        for (String part : name.getParts()) {
            if (result == null) {
                result = new Identifier(part);
                continue;
            }
            result = new DereferenceExpression(result, new Identifier(part));
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.field);
    }
}

