/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Merge;
import com.facebook.presto.sql.tree.MergeInsert;
import com.facebook.presto.sql.tree.MergeUpdate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TableFunctionArgument;
import com.facebook.presto.sql.tree.TableFunctionInvocation;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Update;
import com.facebook.presto.sql.tree.UpdateAssignment;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;

public abstract class DefaultTraversalVisitor<R, C>
extends AstVisitor<R, C> {
    @Override
    protected R visitExtract(Extract node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitCast(Cast node, C context) {
        return this.process(node.getExpression(), context);
    }

    @Override
    protected R visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected R visitCoalesceExpression(CoalesceExpression node, C context) {
        node.getOperands().forEach(operand -> this.process((Node)operand, context));
        return null;
    }

    @Override
    protected R visitAtTimeZone(AtTimeZone node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getTimeZone(), context);
        return null;
    }

    @Override
    protected R visitArrayConstructor(ArrayConstructor node, C context) {
        node.getValues().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected R visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitQuery(Query node, C context) {
        node.getWith().ifPresent(with -> this.process((Node)with, context));
        this.process(node.getQueryBody(), context);
        node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, context));
        return null;
    }

    @Override
    protected R visitWith(With node, C context) {
        node.getQueries().forEach(query -> this.process((Node)query, context));
        return null;
    }

    @Override
    protected R visitWithQuery(WithQuery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitSelect(Select node, C context) {
        node.getSelectItems().forEach(item -> this.process((Node)item, context));
        return null;
    }

    @Override
    protected R visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected R visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected R visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected R visitFunctionCall(FunctionCall node, C context) {
        node.getArguments().forEach(argument -> this.process((Node)argument, context));
        node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, context));
        node.getWindow().ifPresent(window -> this.process((Node)window, context));
        node.getFilter().ifPresent(filter -> this.process((Node)filter, context));
        return null;
    }

    @Override
    protected R visitTableFunctionInvocation(TableFunctionInvocation node, C context) {
        for (TableFunctionArgument argument : node.getArguments()) {
            this.process(argument.getValue(), context);
        }
        return null;
    }

    @Override
    protected R visitGroupingOperation(GroupingOperation node, C context) {
        node.getGroupingColumns().forEach(columnArgument -> this.process((Node)columnArgument, context));
        return null;
    }

    @Override
    protected R visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    public R visitWindow(Window node, C context) {
        node.getPartitionBy().forEach(expression -> this.process((Node)expression, context));
        node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, context));
        node.getFrame().ifPresent(frame -> this.process((Node)frame, context));
        return null;
    }

    @Override
    public R visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        node.getEnd().ifPresent(end -> this.process((Node)end, context));
        return null;
    }

    @Override
    public R visitFrameBound(FrameBound node, C context) {
        node.getValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        node.getWhenClauses().forEach(clause -> this.process((Node)clause, context));
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitInListExpression(InListExpression node, C context) {
        node.getValues().forEach(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected R visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        node.getFalseValue().ifPresent(falseValue -> this.process((Node)falseValue, context));
        return null;
    }

    @Override
    protected R visitTryExpression(TryExpression node, C context) {
        this.process(node.getInnerExpression(), context);
        return null;
    }

    @Override
    protected R visitBindExpression(BindExpression node, C context) {
        node.getValues().forEach(value -> this.process((Node)value, context));
        this.process(node.getFunction(), context);
        return null;
    }

    @Override
    protected R visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitNotExpression(NotExpression node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        node.getWhenClauses().forEach(clause -> this.process((Node)clause, context));
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        node.getEscape().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected R visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitIsNullPredicate(IsNullPredicate node, C context) {
        return this.process(node.getValue(), context);
    }

    @Override
    protected R visitLogicalBinaryExpression(LogicalBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected R visitSubqueryExpression(SubqueryExpression node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitOrderBy(OrderBy node, C context) {
        node.getSortItems().forEach(sortItem -> this.process((Node)sortItem, context));
        return null;
    }

    @Override
    protected R visitSortItem(SortItem node, C context) {
        return this.process(node.getSortKey(), context);
    }

    @Override
    protected R visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        node.getFrom().ifPresent(from -> this.process((Node)from, context));
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        node.getGroupBy().ifPresent(groupBy -> this.process((Node)groupBy, context));
        node.getHaving().ifPresent(having -> this.process((Node)having, context));
        node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, context));
        return null;
    }

    @Override
    protected R visitSetOperation(SetOperation node, C context) {
        node.getRelations().forEach(relation -> this.process((Node)relation, context));
        return null;
    }

    @Override
    protected R visitValues(Values node, C context) {
        node.getRows().forEach(row -> this.process((Node)row, context));
        return null;
    }

    @Override
    protected R visitRow(Row node, C context) {
        node.getItems().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitTableSubquery(TableSubquery node, C context) {
        return this.process(node.getQuery(), context);
    }

    @Override
    protected R visitAliasedRelation(AliasedRelation node, C context) {
        return this.process(node.getRelation(), context);
    }

    @Override
    protected R visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        return null;
    }

    @Override
    protected R visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).map(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected R visitUnnest(Unnest node, C context) {
        node.getExpressions().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitGroupBy(GroupBy node, C context) {
        node.getGroupingElements().forEach(groupingElement -> this.process((Node)groupingElement, context));
        return null;
    }

    @Override
    protected R visitCube(Cube node, C context) {
        return null;
    }

    @Override
    protected R visitRollup(Rollup node, C context) {
        return null;
    }

    @Override
    protected R visitSimpleGroupBy(SimpleGroupBy node, C context) {
        node.getExpressions().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitGroupingSets(GroupingSets node, C context) {
        return null;
    }

    @Override
    protected R visitInsert(Insert node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected R visitUpdate(Update node, C context) {
        this.process(node.getTable(), context);
        node.getAssignments().forEach(value -> this.process((Node)value, context));
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected R visitUpdateAssignment(UpdateAssignment node, C context) {
        this.process(node.getName(), context);
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitMerge(Merge node, C context) {
        this.process(node.getTarget(), context);
        this.process(node.getSource(), context);
        this.process(node.getPredicate(), context);
        node.getMergeCases().forEach(mergeCase -> this.process((Node)mergeCase, context));
        return null;
    }

    @Override
    protected R visitMergeInsert(MergeInsert node, C context) {
        node.getColumns().forEach(column -> this.process((Node)column, context));
        node.getValues().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected R visitMergeUpdate(MergeUpdate node, C context) {
        node.getAssignments().forEach(assignment -> {
            this.process(assignment.getTarget(), context);
            this.process(assignment.getValue(), context);
        });
        return null;
    }

    @Override
    protected R visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        node.getProperties().forEach(property -> this.process((Node)property, context));
        return null;
    }

    @Override
    protected R visitProperty(Property node, C context) {
        this.process(node.getName(), context);
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitAnalyze(Analyze node, C context) {
        node.getProperties().forEach(property -> this.process((Node)property, context));
        return null;
    }

    @Override
    protected R visitCreateView(CreateView node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected R visitCreateMaterializedView(CreateMaterializedView node, C context) {
        this.process(node.getQuery(), context);
        node.getProperties().forEach(property -> this.process((Node)property, context));
        return null;
    }

    @Override
    protected R visitRefreshMaterializedView(RefreshMaterializedView node, C context) {
        this.process(node.getTarget(), context);
        this.process(node.getWhere(), context);
        return null;
    }

    @Override
    protected R visitSetSession(SetSession node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected R visitAddColumn(AddColumn node, C context) {
        this.process(node.getColumn(), context);
        return null;
    }

    @Override
    protected R visitCreateTable(CreateTable node, C context) {
        node.getElements().forEach(tableElement -> this.process((Node)tableElement, context));
        node.getProperties().forEach(property -> this.process((Node)property, context));
        return null;
    }

    @Override
    protected R visitStartTransaction(StartTransaction node, C context) {
        node.getTransactionModes().forEach(transactionMode -> this.process((Node)transactionMode, context));
        return null;
    }

    @Override
    protected R visitExplain(Explain node, C context) {
        this.process(node.getStatement(), context);
        node.getOptions().forEach(option -> this.process((Node)option, context));
        return null;
    }

    @Override
    protected R visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected R visitExists(ExistsPredicate node, C context) {
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected R visitLateral(Lateral node, C context) {
        this.process(node.getQuery(), context);
        return super.visitLateral(node, context);
    }
}

