/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Cast
extends Expression {
    private final Expression expression;
    private final String type;
    private final boolean safe;
    private final boolean typeOnly;

    public Cast(Expression expression, String type) {
        this(Optional.empty(), expression, type, false, false);
    }

    public Cast(Expression expression, String type, boolean safe) {
        this(Optional.empty(), expression, type, safe, false);
    }

    public Cast(Expression expression, String type, boolean safe, boolean typeOnly) {
        this(Optional.empty(), expression, type, safe, typeOnly);
    }

    public Cast(NodeLocation location, Expression expression, String type) {
        this(Optional.of(location), expression, type, false, false);
    }

    public Cast(NodeLocation location, Expression expression, String type, boolean safe) {
        this(Optional.of(location), expression, type, safe, false);
    }

    public Cast(NodeLocation location, Expression expression, String type, boolean safe, boolean typeOnly) {
        this(Optional.of(location), expression, type, safe, typeOnly);
    }

    public Cast(Optional<NodeLocation> location, Expression expression, String type, boolean safe, boolean typeOnly) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(type, "type is null");
        this.expression = expression;
        this.type = Cast.transformCase(type);
        this.safe = safe;
        this.typeOnly = typeOnly;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isTypeOnly() {
        return this.typeOnly;
    }

    private static String transformCase(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean insideQuotes = false;
        int l = input.length();
        for (int i = 0; i < l; ++i) {
            char ch = input.charAt(i);
            if (ch == '\"') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (insideQuotes) {
                sb.append(ch);
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cast o = (Cast)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.type, o.type) && Objects.equals(this.safe, o.safe) && Objects.equals(this.typeOnly, o.typeOnly);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe, this.typeOnly);
    }
}

