/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.testing;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TreeAssertions {
    private TreeAssertions() {
    }

    public static void assertFormattedSql(SqlParser sqlParser, Node expected) {
        ParsingOptions parsingOptions = new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE);
        TreeAssertions.assertFormattedSql(sqlParser, parsingOptions, expected);
    }

    public static void assertFormattedSql(SqlParser sqlParser, ParsingOptions parsingOptions, Node expected) {
        String formatted = SqlFormatter.formatSql(expected, Optional.empty());
        Statement actual = TreeAssertions.parseFormatted(sqlParser, parsingOptions, formatted, expected);
        TreeAssertions.assertEquals(SqlFormatter.formatSql(actual, Optional.empty()), formatted);
        if (!actual.equals(expected)) {
            TreeAssertions.assertListEquals(TreeAssertions.linearizeTree(actual), TreeAssertions.linearizeTree(expected));
        }
        TreeAssertions.assertEquals(actual, expected);
    }

    private static Statement parseFormatted(SqlParser sqlParser, ParsingOptions parsingOptions, String sql, Node tree) {
        try {
            return sqlParser.createStatement(sql, parsingOptions);
        }
        catch (ParsingException e) {
            throw new AssertionError(String.format("failed to parse formatted SQL: %s\nerror: %s\ntree: %s", sql, e.getMessage(), tree), e);
        }
    }

    private static List<Node> linearizeTree(Node tree) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultTraversalVisitor<Node, Void>(){

            @Override
            public Node process(Node node, @Nullable Void context) {
                Node result = (Node)super.process(node, context);
                nodes.add((Object)node);
                return result;
            }
        }.process(tree, (Void)null);
        return nodes.build();
    }

    private static <T> void assertListEquals(List<T> actual, List<T> expected) {
        if (actual.size() != expected.size()) {
            throw new AssertionError((Object)String.format("Lists not equal in size%n%s", TreeAssertions.formatLists(actual, expected)));
        }
        if (!actual.equals(expected)) {
            throw new AssertionError((Object)String.format("Lists not equal at index %s%n%s", TreeAssertions.differingIndex(actual, expected), TreeAssertions.formatLists(actual, expected)));
        }
    }

    private static <T> String formatLists(List<T> actual, List<T> expected) {
        Joiner joiner = Joiner.on((String)"\n    ");
        return String.format("Actual [%s]:%n    %s%nExpected [%s]:%n    %s%n", actual.size(), joiner.join(actual), expected.size(), joiner.join(expected));
    }

    private static <T> int differingIndex(List<T> actual, List<T> expected) {
        for (int i = 0; i < actual.size(); ++i) {
            if (actual.get(i).equals(expected.get(i))) continue;
            return i;
        }
        return actual.size();
    }

    private static <T> void assertEquals(T actual, T expected) {
        if (!actual.equals(expected)) {
            throw new AssertionError((Object)String.format("expected [%s] but found [%s]", expected, actual));
        }
    }
}

