/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlBaseBaseVisitor;
import com.facebook.presto.sql.parser.SqlBaseParser;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BindExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateRole;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.CurrentUser;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DescribeInput;
import com.facebook.presto.sql.tree.DescribeOutput;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropRole;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GrantRoles;
import com.facebook.presto.sql.tree.GrantorSpecification;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.PrincipalSpecification;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.RevokeRoles;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowGrants;
import com.facebook.presto.sql.tree.ShowRoleGrants;
import com.facebook.presto.sql.tree.ShowRoles;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.sql.tree.TransactionMode;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    private int parameterPosition;
    private final ParsingOptions parsingOptions;

    AstBuilder(ParsingOptions parsingOptions) {
        this.parsingOptions = Objects.requireNonNull(parsingOptions, "parsingOptions is null");
    }

    @Override
    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitStandaloneExpression(SqlBaseParser.StandaloneExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitUse(SqlBaseParser.UseContext context) {
        return new Use(AstBuilder.getLocation(context), this.visitIfPresent(context.catalog, Identifier.class), (Identifier)this.visit((ParseTree)context.schema));
    }

    @Override
    public Node visitCreateSchema(SqlBaseParser.CreateSchemaContext context) {
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().property(), Property.class);
        }
        return new CreateSchema(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null, (List<Property>)properties);
    }

    @Override
    public Node visitDropSchema(SqlBaseParser.DropSchemaContext context) {
        return new DropSchema(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null, context.CASCADE() != null);
    }

    @Override
    public Node visitRenameSchema(SqlBaseParser.RenameSchemaContext context) {
        return new RenameSchema(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    @Override
    public Node visitCreateTableAsSelect(SqlBaseParser.CreateTableAsSelectContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Optional<List<Identifier>> columnAliases = Optional.empty();
        if (context.columnAliases() != null) {
            columnAliases = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().property(), Property.class);
        }
        return new CreateTableAsSelect(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()), context.EXISTS() != null, (List<Property>)properties, context.NO() == null, columnAliases, comment);
    }

    @Override
    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().property(), Property.class);
        }
        return new CreateTable(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), this.visit(context.tableElement(), TableElement.class), context.EXISTS() != null, (List<Property>)properties, comment);
    }

    @Override
    public Node visitShowCreateTable(SqlBaseParser.ShowCreateTableContext context) {
        return new ShowCreate(AstBuilder.getLocation(context), ShowCreate.Type.TABLE, this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropView(SqlBaseParser.DropViewContext context) {
        return new DropView(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitInsertInto(SqlBaseParser.InsertIntoContext context) {
        Optional<List<Identifier>> columnAliases = Optional.empty();
        if (context.columnAliases() != null) {
            columnAliases = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        return new Insert(this.getQualifiedName(context.qualifiedName()), columnAliases, (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDelete(SqlBaseParser.DeleteContext context) {
        return new Delete(AstBuilder.getLocation(context), new Table(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName())), this.visitIfPresent(context.booleanExpression(), Expression.class));
    }

    @Override
    public Node visitRenameTable(SqlBaseParser.RenameTableContext context) {
        return new RenameTable(AstBuilder.getLocation(context), this.getQualifiedName(context.from), this.getQualifiedName(context.to));
    }

    @Override
    public Node visitRenameColumn(SqlBaseParser.RenameColumnContext context) {
        return new RenameColumn(AstBuilder.getLocation(context), this.getQualifiedName(context.tableName), (Identifier)this.visit((ParseTree)context.from), (Identifier)this.visit((ParseTree)context.to));
    }

    @Override
    public Node visitAnalyze(SqlBaseParser.AnalyzeContext context) {
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().property(), Property.class);
        }
        return new Analyze(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (List<Property>)properties);
    }

    @Override
    public Node visitAddColumn(SqlBaseParser.AddColumnContext context) {
        return new AddColumn(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (ColumnDefinition)this.visit((ParseTree)context.columnDefinition()));
    }

    @Override
    public Node visitDropColumn(SqlBaseParser.DropColumnContext context) {
        return new DropColumn(AstBuilder.getLocation(context), this.getQualifiedName(context.tableName), (Identifier)this.visit((ParseTree)context.column));
    }

    @Override
    public Node visitCreateView(SqlBaseParser.CreateViewContext context) {
        return new CreateView(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()), context.REPLACE() != null);
    }

    @Override
    public Node visitStartTransaction(SqlBaseParser.StartTransactionContext context) {
        return new StartTransaction(this.visit(context.transactionMode(), TransactionMode.class));
    }

    @Override
    public Node visitCommit(SqlBaseParser.CommitContext context) {
        return new Commit(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitRollback(SqlBaseParser.RollbackContext context) {
        return new Rollback(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitTransactionAccessMode(SqlBaseParser.TransactionAccessModeContext context) {
        return new TransactionAccessMode(AstBuilder.getLocation(context), context.accessMode.getType() == 119);
    }

    @Override
    public Node visitIsolationLevel(SqlBaseParser.IsolationLevelContext context) {
        return (Node)this.visit((ParseTree)context.levelOfIsolation());
    }

    @Override
    public Node visitReadUncommitted(SqlBaseParser.ReadUncommittedContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.READ_UNCOMMITTED);
    }

    @Override
    public Node visitReadCommitted(SqlBaseParser.ReadCommittedContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.READ_COMMITTED);
    }

    @Override
    public Node visitRepeatableRead(SqlBaseParser.RepeatableReadContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.REPEATABLE_READ);
    }

    @Override
    public Node visitSerializable(SqlBaseParser.SerializableContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.SERIALIZABLE);
    }

    @Override
    public Node visitCall(SqlBaseParser.CallContext context) {
        return new Call(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), this.visit(context.callArgument(), CallArgument.class));
    }

    @Override
    public Node visitPrepare(SqlBaseParser.PrepareContext context) {
        return new Prepare(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()), (Statement)this.visit((ParseTree)context.statement()));
    }

    @Override
    public Node visitDeallocate(SqlBaseParser.DeallocateContext context) {
        return new Deallocate(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    @Override
    public Node visitExecute(SqlBaseParser.ExecuteContext context) {
        return new Execute(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitDescribeOutput(SqlBaseParser.DescribeOutputContext context) {
        return new DescribeOutput(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    @Override
    public Node visitDescribeInput(SqlBaseParser.DescribeInputContext context) {
        return new DescribeInput(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    @Override
    public Node visitProperty(SqlBaseParser.PropertyContext context) {
        return new Property(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitQuery(SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(AstBuilder.getLocation(context), this.visitIfPresent(context.with(), With.class), body.getQueryBody(), body.getOrderBy(), body.getLimit());
    }

    @Override
    public Node visitWith(SqlBaseParser.WithContext context) {
        return new With(AstBuilder.getLocation(context), context.RECURSIVE() != null, this.visit(context.namedQuery(), WithQuery.class));
    }

    @Override
    public Node visitNamedQuery(SqlBaseParser.NamedQueryContext context) {
        Optional<List<Identifier>> columns = Optional.empty();
        if (context.columnAliases() != null) {
            columns = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        return new WithQuery(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.name), (Query)this.visit((ParseTree)context.query()), columns);
    }

    @Override
    public Node visitQueryNoWith(SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(AstBuilder.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(AstBuilder.getLocation(context), Optional.empty(), (QueryBody)new QuerySpecification(AstBuilder.getLocation(context), query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), orderBy, AstBuilder.getTextIfPresent(context.limit)), Optional.empty(), Optional.empty());
        }
        return new Query(AstBuilder.getLocation(context), Optional.empty(), term, orderBy, AstBuilder.getTextIfPresent(context.limit));
    }

    @Override
    public Node visitQuerySpecification(SqlBaseParser.QuerySpecificationContext context) {
        Optional<Relation> from = Optional.empty();
        List<SelectItem> selectItems = this.visit(context.selectItem(), SelectItem.class);
        List<Relation> relations = this.visit(context.relation(), Relation.class);
        if (!relations.isEmpty()) {
            Iterator<Relation> iterator = relations.iterator();
            Relation relation = iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(AstBuilder.getLocation(context), Join.Type.IMPLICIT, relation, iterator.next(), Optional.empty());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(AstBuilder.getLocation(context), new Select(AstBuilder.getLocation(context.SELECT()), AstBuilder.isDistinct(context.setQuantifier()), selectItems), from, this.visitIfPresent(context.where, Expression.class), this.visitIfPresent(context.groupBy(), GroupBy.class), this.visitIfPresent(context.having, Expression.class), Optional.empty(), Optional.empty());
    }

    @Override
    public Node visitGroupBy(SqlBaseParser.GroupByContext context) {
        return new GroupBy(AstBuilder.getLocation(context), AstBuilder.isDistinct(context.setQuantifier()), this.visit(context.groupingElement(), GroupingElement.class));
    }

    @Override
    public Node visitSingleGroupingSet(SqlBaseParser.SingleGroupingSetContext context) {
        return new SimpleGroupBy(AstBuilder.getLocation(context), this.visit(context.groupingSet().expression(), Expression.class));
    }

    @Override
    public Node visitRollup(SqlBaseParser.RollupContext context) {
        return new Rollup(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitCube(SqlBaseParser.CubeContext context) {
        return new Cube(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitMultipleGroupingSets(SqlBaseParser.MultipleGroupingSetsContext context) {
        return new GroupingSets(AstBuilder.getLocation(context), context.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    @Override
    public Node visitSetOperation(SqlBaseParser.SetOperationContext context) {
        QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
        boolean distinct = context.setQuantifier() == null || context.setQuantifier().DISTINCT() != null;
        switch (context.operator.getType()) {
            case 179: {
                return new Union(AstBuilder.getLocation(context.UNION()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 86: {
                return new Intersect(AstBuilder.getLocation(context.INTERSECT()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 57: {
                return new Except(AstBuilder.getLocation(context.EXCEPT()), (Relation)left, (Relation)right, distinct);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
    }

    @Override
    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        if (context.qualifiedName() != null) {
            return new AllColumns(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()));
        }
        return new AllColumns(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        return new SingleColumn(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), this.visitIfPresent(context.identifier(), Identifier.class));
    }

    @Override
    public Node visitTable(SqlBaseParser.TableContext context) {
        return new Table(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubquery(SqlBaseParser.SubqueryContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.queryNoWith()));
    }

    @Override
    public Node visitInlineTable(SqlBaseParser.InlineTableContext context) {
        return new Values(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitExplain(SqlBaseParser.ExplainContext context) {
        return new Explain(AstBuilder.getLocation(context), context.ANALYZE() != null, context.VERBOSE() != null, (Statement)this.visit((ParseTree)context.statement()), this.visit(context.explainOption(), ExplainOption.class));
    }

    @Override
    public Node visitExplainFormat(SqlBaseParser.ExplainFormatContext context) {
        switch (context.value.getType()) {
            case 75: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.GRAPHVIZ);
            }
            case 167: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.TEXT);
            }
            case 92: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.JSON);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN format: " + context.value.getText());
    }

    @Override
    public Node visitExplainType(SqlBaseParser.ExplainTypeContext context) {
        switch (context.value.getType()) {
            case 102: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.LOGICAL);
            }
            case 52: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.DISTRIBUTED);
            }
            case 184: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.VALIDATE);
            }
            case 89: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.IO);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN type: " + context.value.getText());
    }

    @Override
    public Node visitShowTables(SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(AstBuilder.getLocation(context), Optional.ofNullable(context.qualifiedName()).map(this::getQualifiedName), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent(context.escape).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowSchemas(SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(AstBuilder.getLocation(context), this.visitIfPresent(context.identifier(), Identifier.class), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent(context.escape).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowCatalogs(SqlBaseParser.ShowCatalogsContext context) {
        return new ShowCatalogs(AstBuilder.getLocation(context), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitShowStats(SqlBaseParser.ShowStatsContext context) {
        return new ShowStats(Optional.of(AstBuilder.getLocation(context)), new Table(this.getQualifiedName(context.qualifiedName())));
    }

    @Override
    public Node visitShowStatsForQuery(SqlBaseParser.ShowStatsForQueryContext context) {
        QuerySpecification specification = (QuerySpecification)this.visitQuerySpecification(context.querySpecification());
        Query query = new Query(Optional.empty(), specification, Optional.empty(), Optional.empty());
        return new ShowStats(Optional.of(AstBuilder.getLocation(context)), new TableSubquery(query));
    }

    @Override
    public Node visitShowCreateView(SqlBaseParser.ShowCreateViewContext context) {
        return new ShowCreate(AstBuilder.getLocation(context), ShowCreate.Type.VIEW, this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitShowFunctions(SqlBaseParser.ShowFunctionsContext context) {
        return new ShowFunctions(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitShowSession(SqlBaseParser.ShowSessionContext context) {
        return new ShowSession(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitSetSession(SqlBaseParser.SetSessionContext context) {
        return new SetSession(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitResetSession(SqlBaseParser.ResetSessionContext context) {
        return new ResetSession(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitCreateRole(SqlBaseParser.CreateRoleContext context) {
        return new CreateRole(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.name), this.getGrantorSpecificationIfPresent(context.grantor()));
    }

    @Override
    public Node visitDropRole(SqlBaseParser.DropRoleContext context) {
        return new DropRole(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.name));
    }

    @Override
    public Node visitGrantRoles(SqlBaseParser.GrantRolesContext context) {
        return new GrantRoles(AstBuilder.getLocation(context), (Set<Identifier>)ImmutableSet.copyOf(this.getIdentifiers(context.roles().identifier())), (Set<PrincipalSpecification>)ImmutableSet.copyOf(this.getPrincipalSpecifications(context.principal())), context.OPTION() != null, this.getGrantorSpecificationIfPresent(context.grantor()));
    }

    @Override
    public Node visitRevokeRoles(SqlBaseParser.RevokeRolesContext context) {
        return new RevokeRoles(AstBuilder.getLocation(context), (Set<Identifier>)ImmutableSet.copyOf(this.getIdentifiers(context.roles().identifier())), (Set<PrincipalSpecification>)ImmutableSet.copyOf(this.getPrincipalSpecifications(context.principal())), context.OPTION() != null, this.getGrantorSpecificationIfPresent(context.grantor()));
    }

    @Override
    public Node visitSetRole(SqlBaseParser.SetRoleContext context) {
        SetRole.Type type = SetRole.Type.ROLE;
        if (context.ALL() != null) {
            type = SetRole.Type.ALL;
        } else if (context.NONE() != null) {
            type = SetRole.Type.NONE;
        }
        return new SetRole(AstBuilder.getLocation(context), type, this.getIdentifierIfPresent(context.role));
    }

    @Override
    public Node visitGrant(SqlBaseParser.GrantContext context) {
        Optional<List<String>> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        return new Grant(AstBuilder.getLocation(context), privileges, context.TABLE() != null, this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.grantee), context.OPTION() != null);
    }

    @Override
    public Node visitRevoke(SqlBaseParser.RevokeContext context) {
        Optional<Object> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        return new Revoke(AstBuilder.getLocation(context), context.OPTION() != null, privileges, context.TABLE() != null, this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.grantee));
    }

    @Override
    public Node visitShowGrants(SqlBaseParser.ShowGrantsContext context) {
        Optional<QualifiedName> tableName = Optional.empty();
        if (context.qualifiedName() != null) {
            tableName = Optional.of(this.getQualifiedName(context.qualifiedName()));
        }
        return new ShowGrants(AstBuilder.getLocation(context), context.TABLE() != null, tableName);
    }

    @Override
    public Node visitShowRoles(SqlBaseParser.ShowRolesContext context) {
        return new ShowRoles(AstBuilder.getLocation(context), this.getIdentifierIfPresent(context.identifier()), context.CURRENT() != null);
    }

    @Override
    public Node visitShowRoleGrants(SqlBaseParser.ShowRoleGrantsContext context) {
        return new ShowRoleGrants(AstBuilder.getLocation(context), this.getIdentifierIfPresent(context.identifier()));
    }

    @Override
    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(AstBuilder.getLocation(context), Join.Type.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                criteria = new JoinUsing(this.visit(context.joinCriteria().identifier(), Identifier.class));
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        Join.Type joinType = context.joinType().LEFT() != null ? Join.Type.LEFT : (context.joinType().RIGHT() != null ? Join.Type.RIGHT : (context.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(AstBuilder.getLocation(context), joinType, left, right, Optional.of(criteria));
    }

    @Override
    public Node visitSampledRelation(SqlBaseParser.SampledRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.aliasedRelation());
        if (context.TABLESAMPLE() == null) {
            return child;
        }
        return new SampledRelation(AstBuilder.getLocation(context), child, AstBuilder.getSamplingMethod((Token)context.sampleType().getChild(0).getPayload()), (Expression)this.visit((ParseTree)context.percentage));
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.identifier() == null) {
            return child;
        }
        List<Identifier> aliases = null;
        if (context.columnAliases() != null) {
            aliases = this.visit(context.columnAliases().identifier(), Identifier.class);
        }
        return new AliasedRelation(AstBuilder.getLocation(context), child, (Identifier)this.visit((ParseTree)context.identifier()), aliases);
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext context) {
        return new Table(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitUnnest(SqlBaseParser.UnnestContext context) {
        return new Unnest(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class), context.ORDINALITY() != null);
    }

    @Override
    public Node visitLateral(SqlBaseParser.LateralContext context) {
        return new Lateral(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getLocation(context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(AstBuilder.getLocation(context), ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(AstBuilder.getLocation(context), child);
        }
        return new IsNotNullPredicate(AstBuilder.getLocation(context), child);
    }

    @Override
    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression result = new LikePredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), this.visitIfPresent(context.escape, Expression.class));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new InListExpression(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query())));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate(AstBuilder.getLocation(context), (Expression)new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query())));
    }

    @Override
    public Node visitQuantifiedComparison(SqlBaseParser.QuantifiedComparisonContext context) {
        return new QuantifiedComparisonExpression(AstBuilder.getLocation(context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), AstBuilder.getComparisonQuantifier(((TerminalNode)context.comparisonQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(AstBuilder.getLocation(context.query()), (Query)this.visit((ParseTree)context.query())));
    }

    @Override
    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
        switch (context.operator.getType()) {
            case 202: {
                return ArithmeticUnaryExpression.negative(AstBuilder.getLocation(context), child);
            }
            case 201: {
                return ArithmeticUnaryExpression.positive(AstBuilder.getLocation(context), child);
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
    }

    @Override
    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(AstBuilder.getLocation(context.CONCAT()), QualifiedName.of("concat"), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
    }

    @Override
    public Node visitAtTimeZone(SqlBaseParser.AtTimeZoneContext context) {
        return new AtTimeZone(AstBuilder.getLocation(context.AT()), (Expression)this.visit((ParseTree)context.valueExpression()), (Expression)this.visit((ParseTree)context.timeZoneSpecifier()));
    }

    @Override
    public Node visitTimeZoneInterval(SqlBaseParser.TimeZoneIntervalContext context) {
        return (Node)this.visit((ParseTree)context.interval());
    }

    @Override
    public Node visitTimeZoneString(SqlBaseParser.TimeZoneStringContext context) {
        return (Node)this.visit((ParseTree)context.string());
    }

    @Override
    public Node visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitRowConstructor(SqlBaseParser.RowConstructorContext context) {
        return new Row(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitArrayConstructor(SqlBaseParser.ArrayConstructorContext context) {
        return new ArrayConstructor(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitCast(SqlBaseParser.CastContext context) {
        boolean isTryCast = context.TRY_CAST() != null;
        return new Cast(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), this.getType(context.type()), isTryCast);
    }

    @Override
    public Node visitSpecialDateTimeFunction(SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Function function = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(AstBuilder.getLocation(context), function, (Integer)Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(AstBuilder.getLocation(context), function);
    }

    @Override
    public Node visitCurrentUser(SqlBaseParser.CurrentUserContext context) {
        return new CurrentUser(AstBuilder.getLocation(context.CURRENT_USER()));
    }

    @Override
    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        Extract.Field field;
        String fieldString = context.identifier().getText();
        try {
            field = Extract.Field.valueOf(fieldString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw AstBuilder.parseError("Invalid EXTRACT field: " + fieldString, context);
        }
        return new Extract(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), field);
    }

    @Override
    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("substr"), this.visit(context.valueExpression(), Expression.class));
    }

    @Override
    public Node visitPosition(SqlBaseParser.PositionContext context) {
        List arguments = Lists.reverse(this.visit(context.valueExpression(), Expression.class));
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("strpos"), (List<Expression>)arguments);
    }

    @Override
    public Node visitNormalize(SqlBaseParser.NormalizeContext context) {
        Expression str = (Expression)this.visit((ParseTree)context.valueExpression());
        String normalForm = Optional.ofNullable(context.normalForm()).map(RuleContext::getText).orElse("NFC");
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("normalize"), (List<Expression>)ImmutableList.of((Object)str, (Object)new StringLiteral(AstBuilder.getLocation(context), normalForm)));
    }

    @Override
    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        return new DereferenceExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.base), (Identifier)this.visit((ParseTree)context.fieldName));
    }

    @Override
    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        return (Node)this.visit((ParseTree)context.identifier());
    }

    @Override
    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(AstBuilder.getLocation(context), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        Optional<Expression> filter = this.visitIfPresent(context.filter(), Expression.class);
        Optional<Window> window = this.visitIfPresent(context.over(), Window.class);
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.visit(context.sortItem(), SortItem.class)));
        }
        QualifiedName name = this.getQualifiedName(context.qualifiedName());
        boolean distinct = AstBuilder.isDistinct(context.setQuantifier());
        if (name.toString().equalsIgnoreCase("if")) {
            AstBuilder.check(context.expression().size() == 2 || context.expression().size() == 3, "Invalid number of arguments for 'if' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'if' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'if' function", context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'if' function", context);
            Expression elseExpression = null;
            if (context.expression().size() == 3) {
                elseExpression = (Expression)this.visit((ParseTree)context.expression(2));
            }
            return new IfExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)), elseExpression);
        }
        if (name.toString().equalsIgnoreCase("nullif")) {
            AstBuilder.check(context.expression().size() == 2, "Invalid number of arguments for 'nullif' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'nullif' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'nullif' function", context);
            return new NullIfExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)));
        }
        if (name.toString().equalsIgnoreCase("coalesce")) {
            AstBuilder.check(context.expression().size() >= 2, "The 'coalesce' function must have at least two arguments", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'coalesce' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'coalesce' function", context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'coalesce' function", context);
            return new CoalesceExpression(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
        }
        if (name.toString().equalsIgnoreCase("try")) {
            AstBuilder.check(context.expression().size() == 1, "The 'try' function must have exactly one argument", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'try' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'try' function", context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'try' function", context);
            return new TryExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)Iterables.getOnlyElement(context.expression())));
        }
        if (name.toString().equalsIgnoreCase("$internal$bind")) {
            AstBuilder.check(context.expression().size() >= 1, "The '$internal$bind' function must have at least one arguments", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for '$internal$bind' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for '$internal$bind' function", context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for '$internal$bind' function", context);
            int numValues = context.expression().size() - 1;
            List arguments = (List)context.expression().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(Expression.class::cast).collect(ImmutableList.toImmutableList());
            return new BindExpression(AstBuilder.getLocation(context), arguments.subList(0, numValues), (Expression)arguments.get(numValues));
        }
        return new FunctionCall(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), window, filter, orderBy, distinct, this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitLambda(SqlBaseParser.LambdaContext context) {
        List<LambdaArgumentDeclaration> arguments = this.visit(context.identifier(), Identifier.class).stream().map(LambdaArgumentDeclaration::new).collect(Collectors.toList());
        Expression body = (Expression)this.visit((ParseTree)context.expression());
        return new LambdaExpression(AstBuilder.getLocation(context), arguments, body);
    }

    @Override
    public Node visitFilter(SqlBaseParser.FilterContext context) {
        return (Node)this.visit((ParseTree)context.booleanExpression());
    }

    @Override
    public Node visitOver(SqlBaseParser.OverContext context) {
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(AstBuilder.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        return new Window(AstBuilder.getLocation(context), this.visit(context.partition, Expression.class), orderBy, this.visitIfPresent(context.windowFrame(), WindowFrame.class));
    }

    @Override
    public Node visitColumnDefinition(SqlBaseParser.ColumnDefinitionContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().property(), Property.class);
        }
        boolean nullable = context.NOT() == null;
        return new ColumnDefinition(AstBuilder.getLocation(context), (Identifier)this.visit((ParseTree)context.identifier()), this.getType(context.type()), nullable, (List<Property>)properties, comment);
    }

    @Override
    public Node visitLikeClause(SqlBaseParser.LikeClauseContext context) {
        return new LikeClause(AstBuilder.getLocation(context), this.getQualifiedName(context.qualifiedName()), Optional.ofNullable(context.optionType).map(AstBuilder::getPropertiesOption));
    }

    @Override
    public Node visitSortItem(SqlBaseParser.SortItemContext context) {
        return new SortItem(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    @Override
    public Node visitWindowFrame(SqlBaseParser.WindowFrameContext context) {
        return new WindowFrame(AstBuilder.getLocation(context), AstBuilder.getFrameType(context.frameType), (FrameBound)this.visit((ParseTree)context.start), this.visitIfPresent(context.end, FrameBound.class));
    }

    @Override
    public Node visitUnboundedFrame(SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(AstBuilder.getLocation(context), AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    @Override
    public Node visitBoundedFrame(SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(AstBuilder.getLocation(context), AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitCurrentRowBound(SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(AstBuilder.getLocation(context), FrameBound.Type.CURRENT_ROW);
    }

    @Override
    public Node visitGroupingOperation(SqlBaseParser.GroupingOperationContext context) {
        List<QualifiedName> arguments = context.qualifiedName().stream().map(this::getQualifiedName).collect(Collectors.toList());
        return new GroupingOperation(Optional.of(AstBuilder.getLocation(context)), arguments);
    }

    @Override
    public Node visitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
        return new Identifier(AstBuilder.getLocation(context), context.getText(), false);
    }

    @Override
    public Node visitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
        String token = context.getText();
        String identifier = token.substring(1, token.length() - 1).replace("\"\"", "\"");
        return new Identifier(AstBuilder.getLocation(context), identifier, true);
    }

    @Override
    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return new NullLiteral(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitBasicStringLiteral(SqlBaseParser.BasicStringLiteralContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitUnicodeStringLiteral(SqlBaseParser.UnicodeStringLiteralContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.decodeUnicodeLiteral(context));
    }

    @Override
    public Node visitBinaryLiteral(SqlBaseParser.BinaryLiteralContext context) {
        String raw = context.BINARY_LITERAL().getText();
        return new BinaryLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(raw.substring(1)));
    }

    @Override
    public Node visitTypeConstructor(SqlBaseParser.TypeConstructorContext context) {
        String value = ((StringLiteral)this.visit((ParseTree)context.string())).getValue();
        if (context.DOUBLE_PRECISION() != null) {
            return new GenericLiteral(AstBuilder.getLocation(context), "DOUBLE", value);
        }
        String type = context.identifier().getText();
        if (type.equalsIgnoreCase("time")) {
            return new TimeLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return new TimestampLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equalsIgnoreCase("decimal")) {
            return new DecimalLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equalsIgnoreCase("char")) {
            return new CharLiteral(AstBuilder.getLocation(context), value);
        }
        return new GenericLiteral(AstBuilder.getLocation(context), type, value);
    }

    @Override
    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        return new LongLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        switch (this.parsingOptions.getDecimalLiteralTreatment()) {
            case AS_DOUBLE: {
                return new DoubleLiteral(AstBuilder.getLocation(context), context.getText());
            }
            case AS_DECIMAL: {
                return new DecimalLiteral(AstBuilder.getLocation(context), context.getText());
            }
            case REJECT: {
                throw new ParsingException("Unexpected decimal literal: " + context.getText());
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    @Override
    public Node visitDoubleLiteral(SqlBaseParser.DoubleLiteralContext context) {
        return new DoubleLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitBooleanValue(SqlBaseParser.BooleanValueContext context) {
        return new BooleanLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitInterval(SqlBaseParser.IntervalContext context) {
        return new IntervalLiteral(AstBuilder.getLocation(context), ((StringLiteral)this.visit((ParseTree)context.string())).getValue(), Optional.ofNullable(context.sign).map(AstBuilder::getIntervalSign).orElse(IntervalLiteral.Sign.POSITIVE), AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload()), Optional.ofNullable(context.to).map(x -> x.getChild(0).getPayload()).map(Token.class::cast).map(AstBuilder::getIntervalFieldType));
    }

    @Override
    public Node visitParameter(SqlBaseParser.ParameterContext context) {
        Parameter parameter = new Parameter(AstBuilder.getLocation(context), this.parameterPosition);
        ++this.parameterPosition;
        return parameter;
    }

    @Override
    public Node visitPositionalArgument(SqlBaseParser.PositionalArgumentContext context) {
        return new CallArgument(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitNamedArgument(SqlBaseParser.NamedArgumentContext context) {
        return new CallArgument(AstBuilder.getLocation(context), context.identifier().getText(), (Expression)this.visit((ParseTree)context.expression()));
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static String decodeUnicodeLiteral(SqlBaseParser.UnicodeStringLiteralContext context) {
        char escape;
        if (context.UESCAPE() != null) {
            String escapeString = AstBuilder.unquote(context.STRING().getText());
            AstBuilder.check(!escapeString.isEmpty(), "Empty Unicode escape character", context);
            AstBuilder.check(escapeString.length() == 1, "Invalid Unicode escape character: " + escapeString, context);
            escape = escapeString.charAt(0);
            AstBuilder.check(AstBuilder.isValidUnicodeEscape(escape), "Invalid Unicode escape character: " + escapeString, context);
        } else {
            escape = '\\';
        }
        String rawContent = AstBuilder.unquote(context.UNICODE_STRING().getText().substring(2));
        StringBuilder unicodeStringBuilder = new StringBuilder();
        StringBuilder escapedCharacterBuilder = new StringBuilder();
        int charactersNeeded = 0;
        UnicodeDecodeState state = UnicodeDecodeState.EMPTY;
        block5: for (int i = 0; i < rawContent.length(); ++i) {
            char ch = rawContent.charAt(i);
            switch (state) {
                case EMPTY: {
                    if (ch == escape) {
                        state = UnicodeDecodeState.ESCAPED;
                        continue block5;
                    }
                    unicodeStringBuilder.append(ch);
                    continue block5;
                }
                case ESCAPED: {
                    if (ch == escape) {
                        unicodeStringBuilder.append(escape);
                        state = UnicodeDecodeState.EMPTY;
                        continue block5;
                    }
                    if (ch == '+') {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 6;
                        continue block5;
                    }
                    if (AstBuilder.isHexDigit(ch)) {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 4;
                        escapedCharacterBuilder.append(ch);
                        continue block5;
                    }
                    throw AstBuilder.parseError("Invalid hexadecimal digit: " + ch, context);
                }
                case UNICODE_SEQUENCE: {
                    AstBuilder.check(AstBuilder.isHexDigit(ch), "Incomplete escape sequence: " + escapedCharacterBuilder.toString(), context);
                    escapedCharacterBuilder.append(ch);
                    if (charactersNeeded == escapedCharacterBuilder.length()) {
                        String currentEscapedCode = escapedCharacterBuilder.toString();
                        escapedCharacterBuilder.setLength(0);
                        int codePoint = Integer.parseInt(currentEscapedCode, 16);
                        AstBuilder.check(Character.isValidCodePoint(codePoint), "Invalid escaped character: " + currentEscapedCode, context);
                        if (Character.isSupplementaryCodePoint(codePoint)) {
                            unicodeStringBuilder.appendCodePoint(codePoint);
                        } else {
                            char currentCodePoint = (char)codePoint;
                            AstBuilder.check(!Character.isSurrogate(currentCodePoint), String.format("Invalid escaped character: %s. Escaped character is a surrogate. Use '\\+123456' instead.", currentEscapedCode), context);
                            unicodeStringBuilder.append(currentCodePoint);
                        }
                        state = UnicodeDecodeState.EMPTY;
                        charactersNeeded = -1;
                        continue block5;
                    }
                    AstBuilder.check(charactersNeeded > escapedCharacterBuilder.length(), "Unexpected escape sequence length: " + escapedCharacterBuilder.length(), context);
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        AstBuilder.check(state == UnicodeDecodeState.EMPTY, "Incomplete escape sequence: " + escapedCharacterBuilder.toString(), context);
        return unicodeStringBuilder.toString();
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private static LikeClause.PropertiesOption getPropertiesOption(Token token) {
        switch (token.getType()) {
            case 82: {
                return LikeClause.PropertiesOption.INCLUDING;
            }
            case 58: {
                return LikeClause.PropertiesOption.EXCLUDING;
            }
        }
        throw new IllegalArgumentException("Unsupported LIKE option type: " + token.getText());
    }

    private QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        List<String> parts = this.visit(context.identifier(), Identifier.class).stream().map(Identifier::getValue).collect(Collectors.toList());
        return QualifiedName.of(parts);
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidUnicodeEscape(char c) {
        return c < '\u007f' && c > ' ' && !AstBuilder.isHexDigit(c) && c != '\"' && c != '+' && c != '\'';
    }

    private static Optional<String> getTextIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(ParseTree::getText);
    }

    private static Optional<String> getTextIfPresent(Token token) {
        return Optional.ofNullable(token).map(Token::getText);
    }

    private Optional<Identifier> getIdentifierIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(c -> (Identifier)this.visit((ParseTree)c));
    }

    private static ArithmeticBinaryExpression.Operator getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 201: {
                return ArithmeticBinaryExpression.Operator.ADD;
            }
            case 202: {
                return ArithmeticBinaryExpression.Operator.SUBTRACT;
            }
            case 203: {
                return ArithmeticBinaryExpression.Operator.MULTIPLY;
            }
            case 204: {
                return ArithmeticBinaryExpression.Operator.DIVIDE;
            }
            case 205: {
                return ArithmeticBinaryExpression.Operator.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private static ComparisonExpression.Operator getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 195: {
                return ComparisonExpression.Operator.EQUAL;
            }
            case 196: {
                return ComparisonExpression.Operator.NOT_EQUAL;
            }
            case 197: {
                return ComparisonExpression.Operator.LESS_THAN;
            }
            case 198: {
                return ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
            }
            case 199: {
                return ComparisonExpression.Operator.GREATER_THAN;
            }
            case 200: {
                return ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
    }

    private static CurrentTime.Function getDateTimeFunctionType(Token token) {
        switch (token.getType()) {
            case 39: {
                return CurrentTime.Function.DATE;
            }
            case 41: {
                return CurrentTime.Function.TIME;
            }
            case 42: {
                return CurrentTime.Function.TIMESTAMP;
            }
            case 100: {
                return CurrentTime.Function.LOCALTIME;
            }
            case 101: {
                return CurrentTime.Function.LOCALTIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unsupported special function: " + token.getText());
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        switch (token.getType()) {
            case 193: {
                return IntervalLiteral.IntervalField.YEAR;
            }
            case 105: {
                return IntervalLiteral.IntervalField.MONTH;
            }
            case 46: {
                return IntervalLiteral.IntervalField.DAY;
            }
            case 79: {
                return IntervalLiteral.IntervalField.HOUR;
            }
            case 104: {
                return IntervalLiteral.IntervalField.MINUTE;
            }
            case 152: {
                return IntervalLiteral.IntervalField.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        switch (token.getType()) {
            case 202: {
                return IntervalLiteral.Sign.NEGATIVE;
            }
            case 201: {
                return IntervalLiteral.Sign.POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unsupported sign: " + token.getText());
    }

    private static WindowFrame.Type getFrameType(Token type) {
        switch (type.getType()) {
            case 134: {
                return WindowFrame.Type.RANGE;
            }
            case 149: {
                return WindowFrame.Type.ROWS;
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 130: {
                return FrameBound.Type.PRECEDING;
            }
            case 66: {
                return FrameBound.Type.FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 130: {
                return FrameBound.Type.UNBOUNDED_PRECEDING;
            }
            case 66: {
                return FrameBound.Type.UNBOUNDED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static SampledRelation.Type getSamplingMethod(Token token) {
        switch (token.getType()) {
            case 21: {
                return SampledRelation.Type.BERNOULLI;
            }
            case 163: {
                return SampledRelation.Type.SYSTEM;
            }
        }
        throw new IllegalArgumentException("Unsupported sampling method: " + token.getText());
    }

    private static LogicalBinaryExpression.Operator getLogicalBinaryOperator(Token token) {
        switch (token.getType()) {
            case 15: {
                return LogicalBinaryExpression.Operator.AND;
            }
            case 121: {
                return LogicalBinaryExpression.Operator.OR;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + token.getText());
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        switch (token.getType()) {
            case 65: {
                return SortItem.NullOrdering.FIRST;
            }
            case 94: {
                return SortItem.NullOrdering.LAST;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 19: {
                return SortItem.Ordering.ASCENDING;
            }
            case 49: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static QuantifiedComparisonExpression.Quantifier getComparisonQuantifier(Token symbol) {
        switch (symbol.getType()) {
            case 12: {
                return QuantifiedComparisonExpression.Quantifier.ALL;
            }
            case 16: {
                return QuantifiedComparisonExpression.Quantifier.ANY;
            }
            case 159: {
                return QuantifiedComparisonExpression.Quantifier.SOME;
            }
        }
        throw new IllegalArgumentException("Unsupported quantifier: " + symbol.getText());
    }

    private String getType(SqlBaseParser.TypeContext type) {
        if (type.baseType() != null) {
            String signature = type.baseType().getText();
            if (type.baseType().DOUBLE_PRECISION() != null) {
                signature = "DOUBLE";
            }
            if (!type.typeParameter().isEmpty()) {
                String typeParameterSignature = type.typeParameter().stream().map(this::typeParameterToString).collect(Collectors.joining(","));
                signature = signature + "(" + typeParameterSignature + ")";
            }
            return signature;
        }
        if (type.ARRAY() != null) {
            return "ARRAY(" + this.getType(type.type(0)) + ")";
        }
        if (type.MAP() != null) {
            return "MAP(" + this.getType(type.type(0)) + "," + this.getType(type.type(1)) + ")";
        }
        if (type.ROW() != null) {
            StringBuilder builder = new StringBuilder("(");
            for (int i = 0; i < type.identifier().size(); ++i) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(this.visit((ParseTree)type.identifier(i))).append(" ").append(this.getType(type.type(i)));
            }
            builder.append(")");
            return "ROW" + builder.toString();
        }
        if (type.INTERVAL() != null) {
            return "INTERVAL " + (Object)((Object)AstBuilder.getIntervalFieldType((Token)type.from.getChild(0).getPayload())) + " TO " + (Object)((Object)AstBuilder.getIntervalFieldType((Token)type.to.getChild(0).getPayload()));
        }
        throw new IllegalArgumentException("Unsupported type specification: " + type.getText());
    }

    private String typeParameterToString(SqlBaseParser.TypeParameterContext typeParameter) {
        if (typeParameter.INTEGER_VALUE() != null) {
            return typeParameter.INTEGER_VALUE().toString();
        }
        if (typeParameter.type() != null) {
            return this.getType(typeParameter.type());
        }
        throw new IllegalArgumentException("Unsupported typeParameter: " + typeParameter.getText());
    }

    private List<Identifier> getIdentifiers(List<SqlBaseParser.IdentifierContext> identifiers) {
        return identifiers.stream().map(context -> (Identifier)this.visit((ParseTree)context)).collect(Collectors.toList());
    }

    private List<PrincipalSpecification> getPrincipalSpecifications(List<SqlBaseParser.PrincipalContext> principals) {
        return principals.stream().map(this::getPrincipalSpecification).collect(Collectors.toList());
    }

    private Optional<GrantorSpecification> getGrantorSpecificationIfPresent(SqlBaseParser.GrantorContext context) {
        return Optional.ofNullable(context).map(this::getGrantorSpecification);
    }

    private GrantorSpecification getGrantorSpecification(SqlBaseParser.GrantorContext context) {
        if (context instanceof SqlBaseParser.SpecifiedPrincipalContext) {
            return new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(this.getPrincipalSpecification(((SqlBaseParser.SpecifiedPrincipalContext)context).principal())));
        }
        if (context instanceof SqlBaseParser.CurrentUserGrantorContext) {
            return new GrantorSpecification(GrantorSpecification.Type.CURRENT_USER, Optional.empty());
        }
        if (context instanceof SqlBaseParser.CurrentRoleGrantorContext) {
            return new GrantorSpecification(GrantorSpecification.Type.CURRENT_ROLE, Optional.empty());
        }
        throw new IllegalArgumentException("Unsupported grantor: " + (Object)((Object)context));
    }

    private PrincipalSpecification getPrincipalSpecification(SqlBaseParser.PrincipalContext context) {
        if (context instanceof SqlBaseParser.UnspecifiedPrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, (Identifier)this.visit((ParseTree)((SqlBaseParser.UnspecifiedPrincipalContext)context).identifier()));
        }
        if (context instanceof SqlBaseParser.UserPrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.USER, (Identifier)this.visit((ParseTree)((SqlBaseParser.UserPrincipalContext)context).identifier()));
        }
        if (context instanceof SqlBaseParser.RolePrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.ROLE, (Identifier)this.visit((ParseTree)((SqlBaseParser.RolePrincipalContext)context).identifier()));
        }
        throw new IllegalArgumentException("Unsupported principal: " + (Object)((Object)context));
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw AstBuilder.parseError(message, context);
        }
    }

    public static NodeLocation getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return AstBuilder.getLocation(terminalNode.getSymbol());
    }

    public static NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return AstBuilder.getLocation(parserRuleContext.getStart());
    }

    public static NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return new NodeLocation(token.getLine(), token.getCharPositionInLine());
    }

    private static ParsingException parseError(String message, ParserRuleContext context) {
        return new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
    }

    private static enum UnicodeDecodeState {
        EMPTY,
        ESCAPED,
        UNICODE_SEQUENCE;

    }
}

