/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.ParsingException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.airlift.log.Logger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.atn.WildcardTransition;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntervalSet;

class ErrorHandler
extends BaseErrorListener {
    private static final Logger LOG = Logger.get(ErrorHandler.class);
    private final Map<Integer, String> specialRules;
    private final Map<Integer, String> specialTokens;
    private final Set<Integer> ignoredRules;

    private ErrorHandler(Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules) {
        this.specialRules = new HashMap<Integer, String>(specialRules);
        this.specialTokens = specialTokens;
        this.ignoredRules = new HashSet<Integer>(ignoredRules);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        try {
            Parser parser = (Parser)recognizer;
            ATN atn = parser.getATN();
            ATNState currentState = (ATNState)atn.states.get(parser.getState());
            HashMultimap candidates = HashMultimap.create();
            Analyzer analyzer = new Analyzer(atn, parser.getVocabulary(), this.specialRules, this.specialTokens, this.ignoredRules, parser.getTokenStream(), (Multimap<Integer, String>)candidates);
            analyzer.process(currentState, parser.getCurrentToken().getTokenIndex(), (RuleContext)parser.getContext());
            String expected = ((Collection)candidates.asMap().entrySet().stream().max(Comparator.comparing(Map.Entry::getKey)).get().getValue()).stream().sorted().collect(Collectors.joining(", "));
            message = String.format("mismatched input '%s'. Expecting: %s", ((Token)offendingSymbol).getText(), expected);
        }
        catch (Exception exception) {
            LOG.error((Throwable)e, "Unexpected failure when handling parsing error. This is likely a bug in the implementation");
        }
        throw new ParsingException(message, e, line, charPositionInLine);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Integer, String> specialRules = new HashMap<Integer, String>();
        private final Map<Integer, String> specialTokens = new HashMap<Integer, String>();
        private final Set<Integer> ignoredRules = new HashSet<Integer>();

        public Builder specialRule(int ruleId, String name) {
            this.specialRules.put(ruleId, name);
            return this;
        }

        public Builder specialToken(int tokenId, String name) {
            this.specialTokens.put(tokenId, name);
            return this;
        }

        public Builder ignoredRule(int ruleId) {
            this.ignoredRules.add(ruleId);
            return this;
        }

        public ErrorHandler build() {
            return new ErrorHandler(this.specialRules, this.specialTokens, this.ignoredRules);
        }
    }

    private static class Analyzer {
        private final ATN atn;
        private final Vocabulary vocabulary;
        private final Map<Integer, String> specialRules;
        private final Map<Integer, String> specialTokens;
        private final Set<Integer> ignoredRules;
        private final TokenStream stream;
        private final Multimap<Integer, String> candidates;

        public Analyzer(ATN atn, Vocabulary vocabulary, Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules, TokenStream stream, Multimap<Integer, String> candidates) {
            this.stream = stream;
            this.atn = atn;
            this.vocabulary = vocabulary;
            this.specialRules = specialRules;
            this.specialTokens = specialTokens;
            this.ignoredRules = ignoredRules;
            this.candidates = candidates;
        }

        private Set<Integer> process(ATNState startState, int tokenIndex, RuleContext next) {
            int currentRule = startState.ruleIndex;
            if (startState.getStateType() == 3 || startState.getStateType() == 2) {
                if (this.specialRules.containsKey(currentRule)) {
                    this.candidates.put((Object)tokenIndex, (Object)this.specialRules.get(currentRule));
                    return Collections.emptySet();
                }
                if (this.ignoredRules.contains(currentRule)) {
                    return Collections.emptySet();
                }
            }
            HashSet<Integer> endTokens = new HashSet<Integer>();
            ArrayDeque<ParsingState> activeStates = new ArrayDeque<ParsingState>();
            activeStates.add(new ParsingState(startState, tokenIndex));
            while (!activeStates.isEmpty()) {
                ParsingState parsingState = (ParsingState)activeStates.poll();
                if (parsingState.state instanceof RuleStopState) {
                    if (next == null) continue;
                    this.process(((RuleTransition)((ATNState)this.atn.states.get((int)next.invokingState)).transition((int)0)).followState, parsingState.tokenIndex, next.parent);
                    continue;
                }
                for (int i = 0; i < parsingState.state.getNumberOfTransitions(); ++i) {
                    int currentToken;
                    Transition transition = parsingState.state.transition(i);
                    if (transition instanceof RuleTransition) {
                        for (int token : this.process(transition.target, parsingState.tokenIndex, null)) {
                            activeStates.add(new ParsingState(((RuleTransition)transition).followState, token));
                        }
                        continue;
                    }
                    if (transition.isEpsilon()) {
                        activeStates.add(new ParsingState(transition.target, parsingState.tokenIndex));
                        continue;
                    }
                    if (transition instanceof WildcardTransition) {
                        throw new UnsupportedOperationException("not yet implemented: wildcard transition");
                    }
                    IntervalSet labels = transition.label();
                    if (transition instanceof NotSetTransition) {
                        labels = labels.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
                    }
                    if (labels.contains(currentToken = this.stream.get(parsingState.tokenIndex).getType())) {
                        activeStates.add(new ParsingState(transition.target, parsingState.tokenIndex + 1));
                        continue;
                    }
                    this.candidates.putAll((Object)parsingState.tokenIndex, this.getTokenNames(labels));
                }
            }
            return endTokens;
        }

        private Set<String> getTokenNames(IntervalSet tokens) {
            return tokens.toSet().stream().map(token -> {
                if (token == -1) {
                    return "<EOF>";
                }
                return this.specialTokens.getOrDefault(token, this.vocabulary.getDisplayName(token.intValue()));
            }).collect(Collectors.toSet());
        }
    }

    private static class ParsingState {
        public final ATNState state;
        public final int tokenIndex;

        public ParsingState(ATNState state, int tokenIndex) {
            this.state = state;
            this.tokenIndex = tokenIndex;
        }
    }
}

