/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Execute
extends Statement {
    private final String name;
    private final List<Expression> parameters;

    public Execute(NodeLocation location, String name, List<Expression> parameters) {
        this(Optional.of(location), name, parameters);
    }

    public Execute(String name, List<Expression> parameters) {
        this(Optional.empty(), name, parameters);
    }

    private Execute(Optional<NodeLocation> location, String name, List<Expression> parameters) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = (List)Objects.requireNonNull(ImmutableList.copyOf(parameters), "parameters is null");
    }

    public String getName() {
        return this.name;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExecute(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.parameters;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Execute o = (Execute)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.parameters, o.parameters);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameters", this.parameters).toString();
    }
}

