/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.ExpressionFormatter;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DescribeInput;
import com.facebook.presto.sql.tree.DescribeOutput;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowGrants;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.sql.tree.TransactionMode;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-z_][a-z0-9_]*");

    private SqlFormatter() {
    }

    public static String formatSql(Node root, Optional<List<Expression>> parameters) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder, parameters).process(root, 0);
        return builder.toString();
    }

    private static void appendAliasColumns(StringBuilder builder, List<String> columns) {
        if (columns != null && !columns.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, columns);
            builder.append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        private final Optional<List<Expression>> parameters;

        public Formatter(StringBuilder builder, Optional<List<Expression>> parameters) {
            this.builder = builder;
            this.parameters = parameters;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node, this.parameters));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitLateral(Lateral node, Integer indent) {
            this.append(indent, "LATERAL (");
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitPrepare(Prepare node, Integer indent) {
            this.append(indent, "PREPARE ");
            this.builder.append(node.getName());
            this.builder.append(" FROM");
            this.builder.append("\n");
            this.process(node.getStatement(), indent + 1);
            return null;
        }

        @Override
        protected Void visitDeallocate(Deallocate node, Integer indent) {
            this.append(indent, "DEALLOCATE PREPARE ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExecute(Execute node, Integer indent) {
            this.append(indent, "EXECUTE ");
            this.builder.append(node.getName());
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append(" USING ");
                Joiner.on((String)", ").appendTo(this.builder, parameters);
            }
            return null;
        }

        @Override
        protected Void visitDescribeOutput(DescribeOutput node, Integer indent) {
            this.append(indent, "DESCRIBE OUTPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitDescribeInput(DescribeInput node, Integer indent) {
            this.append(indent, "DESCRIBE INPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                With with = node.getWith().get();
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, query.getName());
                    query.getColumnNames().ifPresent(columnNames -> SqlFormatter.appendAliasColumns(this.builder, columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            }
            this.processRelation(node.getQueryBody(), indent);
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            if (node.getFrom().isPresent()) {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process(node.getFrom().get(), indent);
            }
            this.builder.append('\n');
            if (node.getWhere().isPresent()) {
                this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(node.getWhere().get(), this.parameters)).append('\n');
            }
            if (node.getGroupBy().isPresent()) {
                this.append(indent, "GROUP BY " + (node.getGroupBy().get().isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(node.getGroupBy().get().getGroupingElements())).append('\n');
            }
            if (node.getHaving().isPresent()) {
                this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(node.getHaving().get(), this.parameters)).append('\n');
            }
            if (node.getOrderBy().isPresent()) {
                this.process(node.getOrderBy().get(), indent);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + node.getLimit().get()).append('\n');
            }
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node, this.parameters)).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression(), this.parameters));
            if (node.getAlias().isPresent()) {
                this.builder.append(' ').append('\"').append(node.getAlias().get()).append('\"');
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(Formatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(ExpressionFormatter.formatExpression(on.getExpression(), this.parameters));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(' ').append(Formatter.formatName(node.getAlias()));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.process(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            return null;
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row, this.parameters));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(Formatter.formatName(node.getName())).append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer context) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            if (node.isAnalyze()) {
                this.builder.append("ANALYZE ");
            }
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer context) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer context) {
            this.builder.append("SHOW SCHEMAS");
            if (node.getCatalog().isPresent()) {
                this.builder.append(" FROM ").append(node.getCatalog().get());
            }
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer context) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(Formatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer context) {
            if (node.getType() == ShowCreate.Type.TABLE) {
                this.builder.append("SHOW CREATE TABLE ").append(Formatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.VIEW) {
                this.builder.append("SHOW CREATE VIEW ").append(Formatter.formatName(node.getName()));
            }
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer context) {
            this.builder.append("SHOW COLUMNS FROM ").append(Formatter.formatName(node.getTable()));
            return null;
        }

        @Override
        protected Void visitShowStats(ShowStats node, Integer context) {
            this.builder.append("SHOW STATS FOR ");
            this.process(node.getRelation(), 0);
            this.builder.append("");
            return null;
        }

        @Override
        protected Void visitShowPartitions(ShowPartitions node, Integer context) {
            this.builder.append("SHOW PARTITIONS FROM ").append(Formatter.formatName(node.getTable()));
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get(), this.parameters));
            }
            if (!node.getOrderBy().isEmpty()) {
                this.builder.append(" ORDER BY ").append(ExpressionFormatter.formatSortItems(node.getOrderBy(), this.parameters));
            }
            if (node.getLimit().isPresent()) {
                this.builder.append(" LIMIT ").append(node.getLimit().get());
            }
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer context) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer context) {
            this.builder.append("SHOW SESSION");
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer context) {
            this.builder.append("DELETE FROM ").append(Formatter.formatName(node.getTable().getName()));
            if (node.getWhere().isPresent()) {
                this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(node.getWhere().get(), this.parameters));
            }
            return null;
        }

        @Override
        protected Void visitCreateSchema(CreateSchema node, Integer context) {
            this.builder.append("CREATE SCHEMA ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getSchemaName()));
            this.appendTableProperties(this.builder, node.getProperties());
            return null;
        }

        @Override
        protected Void visitDropSchema(DropSchema node, Integer context) {
            this.builder.append("DROP SCHEMA ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getSchemaName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitRenameSchema(RenameSchema node, Integer context) {
            this.builder.append("ALTER SCHEMA ").append(Formatter.formatName(node.getSource())).append(" RENAME TO ").append(Formatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatName(node.getName()));
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT " + ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.appendTableProperties(this.builder, node.getProperties());
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = Formatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element instanceof ColumnDefinition) {
                    ColumnDefinition column = (ColumnDefinition)element;
                    return elementIndent + Formatter.formatName(column.getName()) + " " + column.getType() + column.getComment().map(comment -> " COMMENT " + ExpressionFormatter.formatStringLiteral(comment)).orElse("");
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    StringBuilder builder = new StringBuilder(elementIndent);
                    builder.append("LIKE ").append(Formatter.formatName(likeClause.getTableName()));
                    if (likeClause.getPropertiesOption().isPresent()) {
                        builder.append(" ").append(likeClause.getPropertiesOption().get().name()).append(" PROPERTIES");
                    }
                    return builder.toString();
                }
                throw new UnsupportedOperationException("unknown table element: " + element);
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            if (node.getComment().isPresent()) {
                this.builder.append("\nCOMMENT " + ExpressionFormatter.formatStringLiteral(node.getComment().get()));
            }
            this.appendTableProperties(this.builder, node.getProperties());
            return null;
        }

        private void appendTableProperties(StringBuilder builder, Map<String, Expression> properties) {
            if (!properties.isEmpty()) {
                builder.append("\nWITH (\n");
                String propertyList = ImmutableSortedMap.copyOf(properties).entrySet().stream().map(entry -> SqlFormatter.INDENT + Formatter.formatName((String)entry.getKey()) + " = " + ExpressionFormatter.formatExpression((Expression)entry.getValue(), this.parameters)).collect(Collectors.joining(",\n"));
                builder.append(propertyList);
                builder.append("\n").append(")");
            }
        }

        private static String formatName(String name) {
            if (NAME_PATTERN.matcher(name).matches()) {
                return name;
            }
            return "\"" + name + "\"";
        }

        private static String formatName(QualifiedName name) {
            return name.getOriginalParts().stream().map(Formatter::formatName).collect(Collectors.joining("."));
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer context) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTableName());
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(node.getTable()).append(" RENAME COLUMN ").append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer context) {
            this.builder.append("ALTER TABLE ").append(Formatter.formatName(node.getTable())).append(" DROP COLUMN ").append(Formatter.formatName(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ").append(node.getName()).append(" ADD COLUMN ").append(node.getColumn().getName()).append(" ").append(node.getColumn().getType());
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(node.getTarget()).append(" ");
            if (node.getColumns().isPresent()) {
                this.builder.append("(").append(Joiner.on((String)", ").join((Iterable)node.getColumns().get())).append(") ");
            }
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer context) {
            this.builder.append("SET SESSION ").append(node.getName()).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue(), this.parameters));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer context) {
            this.builder.append("RESET SESSION ").append(node.getName());
            return null;
        }

        @Override
        protected Void visitCallArgument(CallArgument node, Integer indent) {
            if (node.getName().isPresent()) {
                this.builder.append(node.getName().get()).append(" => ");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getValue(), this.parameters));
            return null;
        }

        @Override
        protected Void visitCall(Call node, Integer indent) {
            this.builder.append("CALL ").append(node.getName()).append("(");
            Iterator<CallArgument> arguments = node.getArguments().iterator();
            while (arguments.hasNext()) {
                this.process(arguments.next(), indent);
                if (!arguments.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitStartTransaction(StartTransaction node, Integer indent) {
            this.builder.append("START TRANSACTION");
            Iterator<TransactionMode> iterator = node.getTransactionModes().iterator();
            while (iterator.hasNext()) {
                this.builder.append(" ");
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
            return null;
        }

        @Override
        protected Void visitIsolationLevel(Isolation node, Integer indent) {
            this.builder.append("ISOLATION LEVEL ").append(node.getLevel().getText());
            return null;
        }

        @Override
        protected Void visitTransactionAccessMode(TransactionAccessMode node, Integer context) {
            this.builder.append(node.isReadOnly() ? "READ ONLY" : "READ WRITE");
            return null;
        }

        @Override
        protected Void visitCommit(Commit node, Integer context) {
            this.builder.append("COMMIT");
            return null;
        }

        @Override
        protected Void visitRollback(Rollback node, Integer context) {
            this.builder.append("ROLLBACK");
            return null;
        }

        @Override
        public Void visitGrant(Grant node, Integer indent) {
            this.builder.append("GRANT ");
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" TO ").append(node.getGrantee());
            if (node.isWithGrantOption()) {
                this.builder.append(" WITH GRANT OPTION");
            }
            return null;
        }

        @Override
        public Void visitRevoke(Revoke node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isGrantOptionFor()) {
                this.builder.append("GRANT OPTION FOR ");
            }
            if (node.getPrivileges().isPresent()) {
                this.builder.append(node.getPrivileges().get().stream().collect(Collectors.joining(", ")));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.isTable()) {
                this.builder.append("TABLE ");
            }
            this.builder.append(node.getTableName()).append(" FROM ").append(node.getGrantee());
            return null;
        }

        @Override
        public Void visitShowGrants(ShowGrants node, Integer indent) {
            this.builder.append("SHOW GRANTS ");
            if (node.getTableName().isPresent()) {
                this.builder.append("ON ");
                if (node.getTable()) {
                    this.builder.append("TABLE ");
                }
                this.builder.append(node.getTableName().get());
            }
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }
    }
}

