/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BindExpression
extends Expression {
    private final Expression value;
    private final Expression function;

    public BindExpression(Expression value, Expression function) {
        this(Optional.empty(), value, function);
    }

    public BindExpression(NodeLocation location, Expression value, Expression function) {
        this(Optional.of(location), value, function);
    }

    private BindExpression(Optional<NodeLocation> location, Expression value, Expression function) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getFunction() {
        return this.function;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBindExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        return nodes.add((Object)this.value).add((Object)this.function).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindExpression that = (BindExpression)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.function);
    }
}

