/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowTables
extends Statement {
    private final Optional<QualifiedName> schema;
    private final Optional<String> likePattern;

    public ShowTables(Optional<QualifiedName> schema, Optional<String> likePattern) {
        this(Optional.empty(), schema, likePattern);
    }

    public ShowTables(NodeLocation location, Optional<QualifiedName> schema, Optional<String> likePattern) {
        this(Optional.of(location), schema, likePattern);
    }

    private ShowTables(Optional<NodeLocation> location, Optional<QualifiedName> schema, Optional<String> likePattern) {
        super(location);
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(likePattern, "likePattern is null");
        this.schema = schema;
        this.likePattern = likePattern;
    }

    public Optional<QualifiedName> getSchema() {
        return this.schema;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowTables(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema, this.likePattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowTables o = (ShowTables)obj;
        return Objects.equals(this.schema, o.schema) && Objects.equals(this.likePattern, o.likePattern);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", this.schema).add("likePattern", this.likePattern).toString();
    }
}

