/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowSchemas
extends Statement {
    private final Optional<String> catalog;
    private final Optional<String> likePattern;

    public ShowSchemas(Optional<String> catalog, Optional<String> likePattern) {
        this(Optional.empty(), catalog, likePattern);
    }

    public ShowSchemas(NodeLocation location, Optional<String> catalog, Optional<String> likePattern) {
        this(Optional.of(location), catalog, likePattern);
    }

    private ShowSchemas(Optional<NodeLocation> location, Optional<String> catalog, Optional<String> likePattern) {
        super(location);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowSchemas(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return this.catalog.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowSchemas o = (ShowSchemas)obj;
        return Objects.equals(this.catalog, o.catalog);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", this.catalog).toString();
    }
}

