/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowFrame
extends Node {
    private final Type type;
    private final FrameBound start;
    private final Optional<FrameBound> end;

    public WindowFrame(Type type, FrameBound start, Optional<FrameBound> end) {
        this(Optional.empty(), type, start, end);
    }

    public WindowFrame(NodeLocation location, Type type, FrameBound start, Optional<FrameBound> end) {
        this(Optional.of(location), type, start, end);
    }

    private WindowFrame(Optional<NodeLocation> location, Type type, FrameBound start, Optional<FrameBound> end) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.start = Objects.requireNonNull(start, "start is null");
        this.end = Objects.requireNonNull(end, "end is null");
    }

    public Type getType() {
        return this.type;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public Optional<FrameBound> getEnd() {
        return this.end;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFrame(this, context);
    }

    @Override
    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.start);
        this.end.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFrame o = (WindowFrame)obj;
        return Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.start, o.start) && Objects.equals(this.end, o.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.start, this.end});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("start", (Object)this.start).add("end", this.end).toString();
    }

    public static enum Type {
        RANGE,
        ROWS;

    }
}

